/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collections;
import java.util.List;
import net.myrrix.common.PartitionsUtils;
import org.apache.mahout.common.Pair;

public final class MyrrixClientConfiguration {
    public static final int DEFAULT_PORT = 80;
    private String host;
    private int port = 80;
    private boolean secure;
    private File keystoreFile;
    private String keystorePassword;
    private String userName;
    private String password;
    private String allPartitionsSpecification;
    private List<List<Pair<String, Integer>>> partitions;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        Preconditions.checkState((this.allPartitionsSpecification == null ? 1 : 0) != 0, (Object)"allPartitionsSpecification already set");
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.allPartitionsSpecification == null ? 1 : 0) != 0, (Object)"allPartitionsSpecification already set");
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public File getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(File keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAllPartitionsSpecification() {
        return this.allPartitionsSpecification;
    }

    public void setAllPartitionsSpecification(String allPartitionsSpecification) {
        Preconditions.checkState((this.host == null ? 1 : 0) != 0, (Object)"host was already set");
        this.allPartitionsSpecification = allPartitionsSpecification;
        this.partitions = PartitionsUtils.parseAllPartitions((CharSequence)allPartitionsSpecification);
    }

    public List<List<Pair<String, Integer>>> getPartitions() {
        return this.partitions == null ? Collections.singletonList(Collections.singletonList(new Pair((Object)this.host, (Object)this.port))) : this.partitions;
    }
}

