/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import net.myrrix.client.MyrrixClientConfiguration;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.common.LongPair;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientRecommender
implements MyrrixRecommender {
    private static final Logger log = LoggerFactory.getLogger(ClientRecommender.class);
    private static final Splitter COMMA = Splitter.on((char)',');
    private final MyrrixClientConfiguration config;
    private final boolean closeConnection;
    private final List<List<Pair<String, Integer>>> partitions;
    private final Random random;

    public ClientRecommender(MyrrixClientConfiguration config) throws IOException {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
        final String userName = config.getUserName();
        final String password = config.getPassword();
        if (userName != null && password != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(userName, password.toCharArray());
                }
            });
        }
        if (config.getKeystoreFile() != null) {
            log.warn("A keystore file has been specified. This should only be done to accept self-signed certificates in development.");
            HttpsURLConnection.setDefaultSSLSocketFactory(this.buildSSLSocketFactory());
        }
        this.closeConnection = Boolean.valueOf(System.getProperty("client.connection.close"));
        this.partitions = config.getPartitions();
        this.random = RandomUtils.getRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory buildSSLSocketFactory() throws IOException {
        final HostnameVerifier defaultVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return "localhost".equals(hostname) || "127.0.0.1".equals(hostname) || defaultVerifier.verify(hostname, sslSession);
            }
        });
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            File trustStoreFile = this.config.getKeystoreFile();
            String password = this.config.getKeystorePassword();
            Preconditions.checkNotNull((Object)password);
            FileInputStream in = new FileInputStream(trustStoreFile);
            try {
                keyStore.load(in, password.toCharArray());
            }
            finally {
                Closeables.closeQuietly((Closeable)in);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, tmf.getTrustManagers(), null);
            return ctx.getSocketFactory();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        catch (KeyStoreException kse) {
            throw new IOException(kse);
        }
        catch (KeyManagementException kme) {
            throw new IOException(kme);
        }
        catch (CertificateException ce) {
            throw new IOException(ce);
        }
    }

    private HttpURLConnection makeConnection(String path, String method, Long partitionID) throws IOException {
        URL url;
        String protocol = this.config.isSecure() ? "https" : "http";
        Pair<String, Integer> replica = this.choosePartitionAndReplica(partitionID);
        try {
            url = new URL(protocol, (String)replica.getFirst(), (Integer)replica.getSecond(), path);
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException(mue);
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        connection.setDoInput(true);
        connection.setDoOutput(false);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Accept", "text/csv");
        if (this.closeConnection) {
            connection.setRequestProperty("Connection", "close");
        }
        return connection;
    }

    private Pair<String, Integer> choosePartitionAndReplica(Long id) {
        int numPartitions = this.partitions.size();
        List<Pair<String, Integer>> replicas = numPartitions == 1 ? this.partitions.get(0) : (id == null ? this.partitions.get(this.random.nextInt(numPartitions)) : this.partitions.get(this.partition(id)));
        int numReplicas = replicas.size();
        return numReplicas == 1 ? replicas.get(0) : replicas.get(this.random.nextInt(numReplicas));
    }

    private int partition(long id) {
        int numPartitions = this.partitions.size();
        return numPartitions == 1 ? 0 : Math.abs((int)(id % (long)numPartitions));
    }

    public void setPreference(long userID, long itemID) throws TasteException {
        this.setPreference(userID, itemID, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        boolean sendValue = value != 1.0f;
        try {
            HttpURLConnection connection = this.makeConnection("/pref/" + userID + '/' + itemID, "POST", userID);
            connection.setDoOutput(sendValue);
            try {
                if (sendValue) {
                    byte[] bytes = String.valueOf(value).getBytes(Charsets.UTF_8);
                    connection.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
                    connection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
                    OutputStream out = connection.getOutputStream();
                    out.write(bytes);
                    Closeables.closeQuietly((Closeable)out);
                }
                switch (connection.getResponseCode()) {
                    case 200: {
                        return;
                    }
                    case 503: {
                        throw new NotReadyException();
                    }
                    default: {
                        throw new TasteException(String.valueOf(connection.getResponseMessage()));
                    }
                }
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        this.setPreference(userID, itemID, -1.0f);
    }

    public void removePreference(long userID, long itemID, float value) throws TasteException {
        this.setPreference(userID, itemID, -value);
    }

    public float estimatePreference(long userID, long itemID) throws TasteException {
        float[] results = this.estimatePreferences(userID, itemID);
        return results[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public float[] estimatePreferences(long userID, long ... itemIDs) throws TasteException {
        StringBuilder urlPath = new StringBuilder();
        urlPath.append("/estimate/");
        urlPath.append(userID);
        for (long itemID : itemIDs) {
            urlPath.append('/').append(itemID);
        }
        try {
            HttpURLConnection connection = this.makeConnection(urlPath.toString(), "GET", userID);
            try {
                float[] fArray;
                switch (connection.getResponseCode()) {
                    case 200: {
                        break;
                    }
                    case 404: {
                        throw new NoSuchItemException(userID + "/" + Arrays.toString(itemIDs));
                    }
                    case 503: {
                        throw new NotReadyException();
                    }
                    default: {
                        throw new TasteException(String.valueOf(connection.getResponseMessage()));
                    }
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
                try {
                    float[] result = new float[itemIDs.length];
                    for (int i = 0; i < itemIDs.length; ++i) {
                        String line = reader.readLine();
                        result[i] = Float.parseFloat(line);
                    }
                    fArray = result;
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly((Closeable)reader);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)reader);
                return fArray;
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
    }

    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.recommend(userID, howMany, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecommendedItem> recommend(long userID, int howMany, boolean considerKnownItems, IDRescorer rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        StringBuilder urlPath = new StringBuilder();
        urlPath.append("/recommend/");
        urlPath.append(userID);
        urlPath.append("?howMany=").append(howMany);
        if (considerKnownItems) {
            urlPath.append("&considerKnownItems=true");
        }
        HttpURLConnection connection = this.makeConnection(urlPath.toString(), "GET", userID);
        try {
            switch (connection.getResponseCode()) {
                case 200: {
                    break;
                }
                case 404: {
                    throw new NoSuchUserException(userID);
                }
                case 503: {
                    throw new NotReadyException();
                }
                default: {
                    throw new TasteException(String.valueOf(connection.getResponseMessage()));
                }
            }
            List<RecommendedItem> list = ClientRecommender.consumeItems(connection);
            connection.disconnect();
            return list;
        }
        catch (Throwable throwable) {
            try {
                connection.disconnect();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new TasteException((Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RecommendedItem> consumeItems(HttpURLConnection connection) throws IOException {
        ArrayList result = Lists.newArrayList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Iterator tokens = COMMA.split((CharSequence)line).iterator();
                long itemID = Long.parseLong((String)tokens.next());
                float value = Float.parseFloat((String)tokens.next());
                result.add(new GenericRecommendedItem(itemID, value));
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)reader);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecommendedItem> recommendToMany(long[] userIDs, int howMany, boolean considerKnownItems, IDRescorer rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        StringBuilder urlPath = new StringBuilder();
        urlPath.append("/recommendToMany");
        for (long userID : userIDs) {
            urlPath.append('/').append(userID);
        }
        urlPath.append("?howMany=").append(howMany);
        Integer requiredPartition = null;
        for (long userID : userIDs) {
            if (requiredPartition == null) {
                requiredPartition = this.partition(userID);
                continue;
            }
            if (requiredPartition.intValue() == this.partition(userID)) continue;
            throw new IllegalArgumentException("Not all user IDs are on the same partition");
        }
        HttpURLConnection connection = this.makeConnection(urlPath.toString(), "GET", userIDs[0]);
        try {
            switch (connection.getResponseCode()) {
                case 200: {
                    break;
                }
                case 404: {
                    throw new NoSuchUserException(Arrays.toString(userIDs));
                }
                case 503: {
                    throw new NotReadyException();
                }
                default: {
                    throw new TasteException(String.valueOf(connection.getResponseMessage()));
                }
            }
            List<RecommendedItem> list = ClientRecommender.consumeItems(connection);
            connection.disconnect();
            return list;
        }
        catch (Throwable throwable) {
            try {
                connection.disconnect();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new TasteException((Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecommendedItem> recommendToAnonymous(long[] itemIDs, int howMany) throws TasteException {
        StringBuilder urlPath = new StringBuilder();
        urlPath.append("/recommendToAnonymous");
        for (long itemID : itemIDs) {
            urlPath.append('/').append(itemID);
        }
        urlPath.append("?howMany=").append(howMany);
        HttpURLConnection connection = this.makeConnection(urlPath.toString(), "GET", null);
        try {
            switch (connection.getResponseCode()) {
                case 200: {
                    break;
                }
                case 404: {
                    throw new NoSuchItemException(Arrays.toString(itemIDs));
                }
                case 503: {
                    throw new NotReadyException();
                }
                default: {
                    throw new TasteException(String.valueOf(connection.getResponseMessage()));
                }
            }
            List<RecommendedItem> list = ClientRecommender.consumeItems(connection);
            connection.disconnect();
            return list;
        }
        catch (Throwable throwable) {
            try {
                connection.disconnect();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new TasteException((Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany) throws TasteException {
        StringBuilder urlPath = new StringBuilder();
        urlPath.append("/similarity");
        for (long itemID : itemIDs) {
            urlPath.append('/').append(itemID);
        }
        urlPath.append("?howMany=").append(howMany);
        HttpURLConnection connection = this.makeConnection(urlPath.toString(), "GET", null);
        try {
            switch (connection.getResponseCode()) {
                case 200: {
                    break;
                }
                case 404: {
                    throw new NoSuchItemException(Arrays.toString(itemIDs));
                }
                case 503: {
                    throw new NotReadyException();
                }
                default: {
                    throw new TasteException(String.valueOf(connection.getResponseMessage()));
                }
            }
            List<RecommendedItem> list = ClientRecommender.consumeItems(connection);
            connection.disconnect();
            return list;
        }
        catch (Throwable throwable) {
            try {
                connection.disconnect();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new TasteException((Throwable)ioe);
            }
        }
    }

    public List<RecommendedItem> mostSimilarItems(long itemID, int howMany) throws TasteException {
        return this.mostSimilarItems(new long[]{itemID}, howMany);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecommendedItem> recommendedBecause(long userID, long itemID, int howMany) throws TasteException {
        HttpURLConnection connection = this.makeConnection("/because/" + userID + '/' + itemID + "?howMany=" + howMany, "GET", userID);
        try {
            switch (connection.getResponseCode()) {
                case 200: {
                    break;
                }
                case 404: {
                    throw new NoSuchItemException(userID + 47L + itemID);
                }
                case 503: {
                    throw new NotReadyException();
                }
                default: {
                    throw new TasteException(String.valueOf(connection.getResponseMessage()));
                }
            }
            List<RecommendedItem> list = ClientRecommender.consumeItems(connection);
            connection.disconnect();
            return list;
        }
        catch (Throwable throwable) {
            try {
                connection.disconnect();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new TasteException((Throwable)ioe);
            }
        }
    }

    public void ingest(File file) throws TasteException {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            this.ingest(reader);
        }
        catch (IOException ioe) {
            try {
                throw new TasteException((Throwable)ioe);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ingest(Reader reader) throws TasteException {
        try {
            HttpURLConnection connection = this.makeConnection("/ingest", "POST", null);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
            connection.setChunkedStreamingMode(0);
            try {
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), Charsets.UTF_8);
                try {
                    CharStreams.copy((Readable)reader, (Appendable)out);
                }
                finally {
                    Closeables.closeQuietly((Closeable)out);
                }
                switch (connection.getResponseCode()) {
                    case 200: {
                        return;
                    }
                    case 503: {
                        throw new NotReadyException();
                    }
                    default: {
                        throw new TasteException(String.valueOf(connection.getResponseMessage()));
                    }
                }
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        try {
            HttpURLConnection connection = this.makeConnection("/refresh", "POST", null);
            try {
                if (connection.getResponseCode() != 200) {
                    log.warn("Unable to refresh; continuing");
                }
            }
            finally {
                connection.disconnect();
            }
        }
        catch (IOException ioe) {
            log.warn("Unable to refresh; continuing");
        }
    }

    @Deprecated
    public DataModel getDataModel() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.recommend(userID, howMany);
    }

    @Deprecated
    public List<RecommendedItem> mostSimilarItems(long itemID, int howMany, Rescorer<LongPair> rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.mostSimilarItems(itemID, howMany);
    }

    @Deprecated
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, Rescorer<LongPair> rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.mostSimilarItems(itemIDs, howMany);
    }

    @Deprecated
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, boolean excludeItemIfNotSimilarToAll) throws TasteException {
        if (excludeItemIfNotSimilarToAll) {
            throw new UnsupportedOperationException();
        }
        return this.mostSimilarItems(itemIDs, howMany);
    }

    @Deprecated
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, Rescorer<LongPair> rescorer, boolean excludeItemIfNotSimilarToAll) throws TasteException {
        if (excludeItemIfNotSimilarToAll || rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.mostSimilarItems(itemIDs, howMany);
    }
}

