/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client;

import java.io.File;
import java.util.Locale;
import net.myrrix.client.CLICommand;
import net.myrrix.client.ClientRecommender;
import net.myrrix.client.MyrrixClientConfiguration;
import net.myrrix.client.translating.TranslatedRecommendedItem;
import net.myrrix.client.translating.TranslatingClientRecommender;
import net.myrrix.client.translating.TranslatingRecommender;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

public final class CLI {
    private static final String TRANSLATE_FLAG = "translate";
    private static final String HOST_FLAG = "host";
    private static final String ALL_PARTITIONS_FLAG = "allPartitions";
    private static final String PORT_FLAG = "port";
    private static final String SECURE_FLAG = "secure";
    private static final String USER_NAME_FLAG = "userName";
    private static final String PASSWORD_FLAG = "password";
    private static final String KEYSTORE_FILE_FLAG = "keystoreFile";
    private static final String KEYSTORE_PASSWORD_FLAG = "keystorePassword";

    private CLI() {
    }

    public static void main(String[] args) throws Exception {
        CLICommand command;
        CommandLine commandLine;
        Options options = CLI.buildOptions();
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (MissingOptionException moe) {
            return;
        }
        String[] programArgs = commandLine.getArgs();
        if (programArgs.length == 0) {
            CLI.printHelp(options);
            return;
        }
        try {
            command = CLICommand.valueOf(programArgs[0].toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            CLI.printHelp(options);
            return;
        }
        MyrrixClientConfiguration config = CLI.buildConfiguration(commandLine);
        ClientRecommender recommender = new ClientRecommender(config);
        TranslatingClientRecommender translatingRecommender = null;
        if (commandLine.hasOption(TRANSLATE_FLAG)) {
            translatingRecommender = new TranslatingClientRecommender(recommender);
            String translateFileName = commandLine.getOptionValue(TRANSLATE_FLAG);
            if (translateFileName != null) {
                File translateFile = new File(translateFileName);
                translatingRecommender.addItemIDs(translateFile);
            }
        }
        boolean success = false;
        switch (command) {
            case SETPREFERENCE: {
                success = CLI.doSetPreference(programArgs, recommender, translatingRecommender);
                break;
            }
            case REMOVEPREFERENCE: {
                success = CLI.doRemovePreference(programArgs, recommender, translatingRecommender);
                break;
            }
            case INGEST: {
                success = CLI.doIngest(programArgs, recommender, translatingRecommender);
                break;
            }
            case ESTIMATEPREFERENCE: {
                success = CLI.doEstimatePreference(programArgs, recommender, translatingRecommender);
                break;
            }
            case RECOMMEND: {
                success = CLI.doRecommend(programArgs, recommender, translatingRecommender);
                break;
            }
            case RECOMMENDTOANONYMOUS: {
                success = CLI.doRecommendToAnonymous(programArgs, recommender, translatingRecommender);
                break;
            }
            case MOSTSIMILARITEMS: {
                success = CLI.doMostSimilarItems(programArgs, recommender, translatingRecommender);
                break;
            }
            case RECOMMENDEDBECAUSE: {
                success = CLI.doRecommendedBecause(programArgs, recommender, translatingRecommender);
                break;
            }
            case REFRESH: {
                success = CLI.doRefresh(programArgs, recommender);
            }
        }
        if (!success) {
            CLI.printHelp(options);
        }
    }

    private static boolean doRefresh(String[] programArgs, ClientRecommender recommender) {
        if (programArgs.length != 1) {
            return false;
        }
        recommender.refresh(null);
        return true;
    }

    private static boolean doRecommendedBecause(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 4) {
            return false;
        }
        int howMany = Integer.parseInt(programArgs[3]);
        if (translatingRecommender == null) {
            long userID = Long.parseLong(programArgs[1]);
            long itemID = Long.parseLong(programArgs[2]);
            CLI.output(recommender.recommendedBecause(userID, itemID, howMany));
        } else {
            String userID = programArgs[1];
            String itemID = programArgs[2];
            CLI.outputTranslated(translatingRecommender.recommendedBecause(userID, itemID, howMany));
        }
        return true;
    }

    private static boolean doMostSimilarItems(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length < 3) {
            return false;
        }
        int howMany = Integer.parseInt(programArgs[programArgs.length - 1]);
        if (translatingRecommender == null) {
            long[] itemIDs = new long[programArgs.length - 2];
            for (int i = 1; i < programArgs.length - 1; ++i) {
                itemIDs[i - 1] = Long.parseLong(programArgs[i]);
            }
            CLI.output(recommender.mostSimilarItems(itemIDs, howMany));
        } else {
            String[] itemIDs = new String[programArgs.length - 2];
            System.arraycopy(programArgs, 1, itemIDs, 0, programArgs.length - 2);
            CLI.outputTranslated(translatingRecommender.mostSimilarItems(itemIDs, howMany));
        }
        return true;
    }

    private static boolean doRecommendToAnonymous(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length < 3) {
            return false;
        }
        int howMany = Integer.parseInt(programArgs[programArgs.length - 1]);
        if (translatingRecommender == null) {
            long[] itemIDs = new long[programArgs.length - 2];
            for (int i = 1; i < programArgs.length - 1; ++i) {
                itemIDs[i - 1] = Long.parseLong(programArgs[i]);
            }
            CLI.output(recommender.recommendToAnonymous(itemIDs, howMany));
        } else {
            String[] itemIDs = new String[programArgs.length - 2];
            System.arraycopy(programArgs, 1, itemIDs, 0, programArgs.length - 2);
            CLI.outputTranslated(translatingRecommender.recommendToAnonymous(itemIDs, howMany));
        }
        return true;
    }

    private static boolean doRecommend(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        boolean considerKnownItems;
        if (programArgs.length != 3 && programArgs.length != 4) {
            return false;
        }
        int howMany = Integer.parseInt(programArgs[2]);
        boolean bl = considerKnownItems = programArgs.length == 4 && Boolean.valueOf(programArgs[3]) != false;
        if (translatingRecommender == null) {
            long userID = Long.parseLong(programArgs[1]);
            CLI.output(recommender.recommend(userID, howMany, considerKnownItems, null));
        } else {
            String userID = programArgs[1];
            CLI.outputTranslated(translatingRecommender.recommend(userID, howMany, considerKnownItems));
        }
        return true;
    }

    private static boolean doEstimatePreference(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        float estimate;
        if (programArgs.length != 3) {
            return false;
        }
        if (translatingRecommender == null) {
            long userID = Long.parseLong(programArgs[1]);
            long itemID = Long.parseLong(programArgs[2]);
            estimate = recommender.estimatePreference(userID, itemID);
        } else {
            String userID = programArgs[1];
            String itemID = programArgs[2];
            estimate = translatingRecommender.estimatePreference(userID, itemID);
        }
        System.out.println(estimate);
        return true;
    }

    private static boolean doIngest(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 2) {
            return false;
        }
        File ingestFile = new File(programArgs[1]);
        if (translatingRecommender == null) {
            recommender.ingest(ingestFile);
        } else {
            translatingRecommender.ingest(ingestFile);
        }
        return true;
    }

    private static boolean doRemovePreference(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 3 && programArgs.length != 4) {
            return false;
        }
        if (translatingRecommender == null) {
            long userID = Long.parseLong(programArgs[1]);
            long itemID = Long.parseLong(programArgs[2]);
            if (programArgs.length == 3) {
                recommender.removePreference(userID, itemID);
            } else {
                float value = Float.parseFloat(programArgs[3]);
                recommender.removePreference(userID, itemID, value);
            }
        } else {
            String userID = programArgs[1];
            String itemID = programArgs[2];
            if (programArgs.length == 3) {
                translatingRecommender.removePreference(userID, itemID);
            } else {
                float value = Float.parseFloat(programArgs[3]);
                translatingRecommender.removePreference(userID, itemID, value);
            }
        }
        return true;
    }

    private static boolean doSetPreference(String[] programArgs, ClientRecommender recommender, TranslatingRecommender translatingRecommender) throws TasteException {
        if (programArgs.length != 3 && programArgs.length != 4) {
            return false;
        }
        if (translatingRecommender == null) {
            long userID = Long.parseLong(programArgs[1]);
            long itemID = Long.parseLong(programArgs[2]);
            if (programArgs.length == 3) {
                recommender.setPreference(userID, itemID);
            } else {
                float value = Float.parseFloat(programArgs[3]);
                recommender.setPreference(userID, itemID, value);
            }
        } else {
            String userID = programArgs[1];
            String itemID = programArgs[2];
            if (programArgs.length == 3) {
                translatingRecommender.setPreference(userID, itemID);
            } else {
                float value = Float.parseFloat(programArgs[3]);
                translatingRecommender.setPreference(userID, itemID, value);
            }
        }
        return true;
    }

    private static void printHelp(Options options) {
        System.out.println("Myrrix Client command line interface. Copyright 2012 Myrrix Ltd, except for included ");
        System.out.println("third-party open source software. Full details of licensing at http://myrrix.com/legal/");
        System.out.println();
        new HelpFormatter().printHelp(CLI.class.getSimpleName() + " [flags] command [arg0 arg1 ...]", options);
    }

    private static MyrrixClientConfiguration buildConfiguration(CommandLine commandLine) throws ParseException {
        boolean hasAllPartitions;
        MyrrixClientConfiguration config = new MyrrixClientConfiguration();
        boolean hasHost = commandLine.hasOption(HOST_FLAG);
        if (hasHost == (hasAllPartitions = commandLine.hasOption(ALL_PARTITIONS_FLAG))) {
            throw new ParseException("Only one of --host and --allPartitions may be set");
        }
        if (hasHost) {
            config.setHost(commandLine.getOptionValue(HOST_FLAG));
        }
        if (commandLine.hasOption(PORT_FLAG)) {
            config.setPort(Integer.parseInt(commandLine.getOptionValue(PORT_FLAG)));
        }
        if (hasAllPartitions) {
            config.setAllPartitionsSpecification(commandLine.getOptionValue(ALL_PARTITIONS_FLAG));
        }
        if (commandLine.hasOption(SECURE_FLAG)) {
            config.setSecure(true);
        }
        if (commandLine.hasOption(USER_NAME_FLAG)) {
            config.setUserName(commandLine.getOptionValue(USER_NAME_FLAG));
        }
        if (commandLine.hasOption(PASSWORD_FLAG)) {
            config.setPassword(commandLine.getOptionValue(PASSWORD_FLAG));
        }
        if (commandLine.hasOption(KEYSTORE_FILE_FLAG)) {
            config.setKeystoreFile(new File(commandLine.getOptionValue(KEYSTORE_FILE_FLAG)));
        }
        if (commandLine.hasOption(KEYSTORE_PASSWORD_FLAG)) {
            config.setKeystorePassword(commandLine.getOptionValue(KEYSTORE_PASSWORD_FLAG));
        }
        return config;
    }

    private static Options buildOptions() {
        Options options = new Options();
        CLI.addOption(options, "Serving Layer port number", HOST_FLAG, true, false);
        CLI.addOption(options, "Serving Layer port number", PORT_FLAG, true, false);
        CLI.addOption(options, "If set, use HTTPS instead of HTTP", SECURE_FLAG, false, true);
        CLI.addOption(options, "Password to authenticate to Serving Layer", USER_NAME_FLAG, true, false);
        CLI.addOption(options, "Password to authenticate to Serving Layer", PASSWORD_FLAG, true, false);
        CLI.addOption(options, "Test SSL certificate keystore to accept", KEYSTORE_FILE_FLAG, true, false);
        CLI.addOption(options, "Password for keystoreFile", KEYSTORE_PASSWORD_FLAG, true, false);
        CLI.addOption(options, "Use String IDs in client API. Optional file argument contains list of all known item IDs", TRANSLATE_FLAG, true, true);
        CLI.addOption(options, "All partitions, as comma-separated host:port (e.g. foo1:8080,foo2:80,bar1:8081)", ALL_PARTITIONS_FLAG, true, false);
        return options;
    }

    private static void addOption(Options options, String description, String longOpt, boolean hasArg, boolean argOptional) {
        if (hasArg) {
            if (argOptional) {
                OptionBuilder.hasOptionalArg();
            } else {
                OptionBuilder.hasArg();
            }
        }
        OptionBuilder.withDescription((String)description);
        OptionBuilder.withLongOpt((String)longOpt);
        options.addOption(OptionBuilder.create());
    }

    private static void output(Iterable<RecommendedItem> items) {
        for (RecommendedItem item : items) {
            System.out.println(item.getItemID() + "," + item.getValue());
        }
    }

    private static void outputTranslated(Iterable<TranslatedRecommendedItem> items) {
        for (TranslatedRecommendedItem item : items) {
            System.out.println(item.getItemID() + ',' + item.getValue());
        }
    }
}

