/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.response;

import net.motionintelligence.client.api.TravelOptions;
import net.motionintelligence.client.api.response.statistics.StatisticResult;
import net.motionintelligence.client.api.util.JsonUtil;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsResponse.class);
    private final long requestTimeMillis;
    private final long totalTimeMillis;
    private final TravelOptions travelOptions;
    private final StatisticResult statisticResult;

    public StatisticsResponse(TravelOptions travelOptions, JSONObject result, long requestStart) {
        this.travelOptions = travelOptions;
        this.requestTimeMillis = result.has("requestTime") ? JsonUtil.getLong(result, "requestTime") : -1L;
        this.totalTimeMillis = System.currentTimeMillis() - requestStart;
        this.statisticResult = new StatisticResult(travelOptions, result);
    }

    public StatisticsResponse(TravelOptions travelOptions, String string, long roundTripTime, long requestStart) {
        this.travelOptions = travelOptions;
        this.requestTimeMillis = roundTripTime;
        this.totalTimeMillis = System.currentTimeMillis() - requestStart;
        this.statisticResult = null;
    }

    public long getRequestTimeMillis() {
        return this.requestTimeMillis;
    }

    public long getTotalTimeMillis() {
        return this.totalTimeMillis;
    }

    public TravelOptions getTravelOptions() {
        return this.travelOptions;
    }

    public StatisticResult getStatisticResult() {
        return this.statisticResult;
    }
}

