/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.request;

import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.motionintelligence.client.api.TravelOptions;
import net.motionintelligence.client.api.exception.Route360ClientException;
import net.motionintelligence.client.api.geo.Coordinate;
import net.motionintelligence.client.api.response.OverpassResponse;
import net.motionintelligence.client.api.util.IOUtil;
import net.motionintelligence.client.api.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverpassRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OverpassRequest.class);
    private Client client;
    private TravelOptions travelOptions;
    private static final String CALLBACK = "callback";

    public OverpassRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public OverpassRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public static void main(String[] args) throws Route360ClientException {
        TravelOptions tp = new TravelOptions();
        tp.setOverpassServiceUrl("https://api5.eu.route360.net:8081/");
        tp.setOverpassQuery("[maxsize:12147483648][timeout:3600][out:json]\n[bbox:47.2701115,5.8663425,55.0815,15.0418962];\n(\n  node['tourism'='hotel'];\n  way['tourism'='hotel'];\n);\nout center;");
        long start = System.currentTimeMillis();
        try {
            OverpassResponse overpassResponse = new OverpassRequest(tp).get();
            Map<String, Coordinate> targets = overpassResponse.getTargets();
            System.out.println(String.format("Targets: %s", targets.size()));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(String.format("Failed after: %sms", System.currentTimeMillis() - start));
        }
    }

    public OverpassResponse get() throws Route360ClientException {
        long requestStart = System.currentTimeMillis();
        WebTarget target = this.client.target(this.travelOptions.getOverpassServiceUrl()).path("/api/interpreter");
        LOGGER.info(String.format("%s", target.getUri()));
        if (this.travelOptions.getOverpassQuery() == null || this.travelOptions.getOverpassQuery().isEmpty()) {
            throw new Route360ClientException("Empty query");
        }
        Entity entity = Entity.entity((Object)this.travelOptions.getOverpassQuery(), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        LOGGER.debug(String.format("Executing overpass query to URI: '%s'", target.getUri()));
        Response response = target.request().post(entity);
        return this.validateResponse(response, requestStart);
    }

    private OverpassResponse validateResponse(Response response, long requestStart) throws Route360ClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return new OverpassResponse(this.travelOptions, JsonUtil.parseString(IOUtil.getResultString(response)), requestStart);
        }
        throw new Route360ClientException((String)response.readEntity(String.class), null);
    }
}

