/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.enums;

import net.motionintelligence.client.api.exception.Route360ClientException;
import net.motionintelligence.client.api.exception.Route360ClientRuntimeException;

public enum PathSerializerType {
    TRAVEL_TIME_PATH_SERIALIZER,
    COMPACT_PATH_SERIALIZER,
    GEO_JSON_PATH_SERIALIZER;


    public static PathSerializerType getPathSerializer(String key) throws Route360ClientException {
        switch (key) {
            case "travelTime": {
                return TRAVEL_TIME_PATH_SERIALIZER;
            }
            case "compact": {
                return COMPACT_PATH_SERIALIZER;
            }
            case "geojson": {
                return GEO_JSON_PATH_SERIALIZER;
            }
        }
        throw new Route360ClientException(String.format("No path serializer available for key '%s'.", key));
    }

    public String getPathSerializerName() throws Route360ClientRuntimeException {
        switch (this) {
            case COMPACT_PATH_SERIALIZER: {
                return "compact";
            }
            case GEO_JSON_PATH_SERIALIZER: {
                return "geojson";
            }
        }
        throw new Route360ClientRuntimeException(String.format("No polygon serializer name available for key '%s'.", new Object[]{this}));
    }
}

