/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.unary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import net.mintern.functions.nullary.NilToObj;
import net.mintern.functions.unary.checked.ObjToObjE;

@FunctionalInterface
public interface ObjToObj<T, R>
extends ObjToObjE<T, R, RuntimeException>,
Function<T, R> {
    public static <T, R, E extends Exception> ObjToObj<T, R> unchecked(Function<? super E, RuntimeException> toRuntime, ObjToObjE<T, R, E> f) {
        return t -> {
            try {
                return f.call(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <T, R, E extends Exception> ObjToObj<T, R> unchecked(ObjToObjE<T, R, E> f) {
        return ObjToObj.unchecked(RuntimeException::new, f);
    }

    public static <T, R, E extends IOException> ObjToObj<T, R> uncheckedIO(ObjToObjE<T, R, E> f) {
        return ObjToObj.unchecked(UncheckedIOException::new, f);
    }

    public static <T, R> NilToObj<R> bind(ObjToObj<T, R> f, T t) {
        return () -> f.call(t);
    }

    default public NilToObj<R> bind(T t) {
        return ObjToObj.bind(this, t);
    }

    @Override
    default public R apply(T t) {
        return this.call(t);
    }
}

