/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.unary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.mintern.functions.nullary.NilToNil;
import net.mintern.functions.unary.checked.ObjToNilE;

@FunctionalInterface
public interface ObjToNil<T>
extends ObjToNilE<T, RuntimeException>,
Consumer<T> {
    public static <T, E extends Exception> ObjToNil<T> unchecked(Function<? super E, RuntimeException> toRuntime, ObjToNilE<T, E> f) {
        return t -> {
            try {
                f.call(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <T, E extends Exception> ObjToNil<T> unchecked(ObjToNilE<T, E> f) {
        return ObjToNil.unchecked(RuntimeException::new, f);
    }

    public static <T, E extends IOException> ObjToNil<T> uncheckedIO(ObjToNilE<T, E> f) {
        return ObjToNil.unchecked(UncheckedIOException::new, f);
    }

    public static <T> NilToNil bind(ObjToNil<T> f, T t) {
        return () -> f.call(t);
    }

    default public NilToNil bind(T t) {
        return ObjToNil.bind(this, t);
    }

    @Override
    default public void accept(T t) {
        this.call(t);
    }
}

