/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.unary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.mintern.functions.nullary.NilToInt;
import net.mintern.functions.unary.checked.ObjToIntE;

@FunctionalInterface
public interface ObjToInt<T>
extends ObjToIntE<T, RuntimeException>,
ToIntFunction<T> {
    public static <T, E extends Exception> ObjToInt<T> unchecked(Function<? super E, RuntimeException> toRuntime, ObjToIntE<T, E> f) {
        return t -> {
            try {
                return f.call(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <T, E extends Exception> ObjToInt<T> unchecked(ObjToIntE<T, E> f) {
        return ObjToInt.unchecked(RuntimeException::new, f);
    }

    public static <T, E extends IOException> ObjToInt<T> uncheckedIO(ObjToIntE<T, E> f) {
        return ObjToInt.unchecked(UncheckedIOException::new, f);
    }

    public static <T> NilToInt bind(ObjToInt<T> f, T t) {
        return () -> f.call(t);
    }

    default public NilToInt bind(T t) {
        return ObjToInt.bind(this, t);
    }

    @Override
    default public int applyAsInt(T t) {
        return this.call(t);
    }
}

