/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.unary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.mintern.functions.nullary.NilToDbl;
import net.mintern.functions.unary.checked.ObjToDblE;

@FunctionalInterface
public interface ObjToDbl<T>
extends ObjToDblE<T, RuntimeException>,
ToDoubleFunction<T> {
    public static <T, E extends Exception> ObjToDbl<T> unchecked(Function<? super E, RuntimeException> toRuntime, ObjToDblE<T, E> f) {
        return t -> {
            try {
                return f.call(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <T, E extends Exception> ObjToDbl<T> unchecked(ObjToDblE<T, E> f) {
        return ObjToDbl.unchecked(RuntimeException::new, f);
    }

    public static <T, E extends IOException> ObjToDbl<T> uncheckedIO(ObjToDblE<T, E> f) {
        return ObjToDbl.unchecked(UncheckedIOException::new, f);
    }

    public static <T> NilToDbl bind(ObjToDbl<T> f, T t) {
        return () -> f.call(t);
    }

    default public NilToDbl bind(T t) {
        return ObjToDbl.bind(this, t);
    }

    @Override
    default public double applyAsDouble(T t) {
        return this.call(t);
    }
}

