/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.unary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.function.Predicate;
import net.mintern.functions.nullary.NilToBool;
import net.mintern.functions.unary.checked.ObjToBoolE;

@FunctionalInterface
public interface ObjToBool<T>
extends ObjToBoolE<T, RuntimeException>,
Predicate<T> {
    public static <T, E extends Exception> ObjToBool<T> unchecked(Function<? super E, RuntimeException> toRuntime, ObjToBoolE<T, E> f) {
        return t -> {
            try {
                return f.call(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <T, E extends Exception> ObjToBool<T> unchecked(ObjToBoolE<T, E> f) {
        return ObjToBool.unchecked(RuntimeException::new, f);
    }

    public static <T, E extends IOException> ObjToBool<T> uncheckedIO(ObjToBoolE<T, E> f) {
        return ObjToBool.unchecked(UncheckedIOException::new, f);
    }

    public static <T> NilToBool bind(ObjToBool<T> f, T t) {
        return () -> f.call(t);
    }

    default public NilToBool bind(T t) {
        return ObjToBool.bind(this, t);
    }

    @Override
    default public boolean test(T t) {
        return this.call(t);
    }
}

