/*
 * Decompiled with CFR 0.152.
 */
package net.mintern.functions.unary;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.mintern.functions.nullary.NilToObj;
import net.mintern.functions.unary.checked.IntToObjE;

@FunctionalInterface
public interface IntToObj<R>
extends IntToObjE<R, RuntimeException>,
IntFunction<R> {
    public static <R, E extends Exception> IntToObj<R> unchecked(Function<? super E, RuntimeException> toRuntime, IntToObjE<R, E> f) {
        return i -> {
            try {
                return f.call(i);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (RuntimeException)toRuntime.apply((Object)e);
            }
        };
    }

    public static <R, E extends Exception> IntToObj<R> unchecked(IntToObjE<R, E> f) {
        return IntToObj.unchecked(RuntimeException::new, f);
    }

    public static <R, E extends IOException> IntToObj<R> uncheckedIO(IntToObjE<R, E> f) {
        return IntToObj.unchecked(UncheckedIOException::new, f);
    }

    public static <R> NilToObj<R> bind(IntToObj<R> f, int i) {
        return () -> f.call(i);
    }

    default public NilToObj<R> bind(int i) {
        return IntToObj.bind(this, i);
    }

    @Override
    default public R apply(int i) {
        return this.call(i);
    }
}

