/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.util;

import cn.hutool.json.JSONUtil;
import java.util.Map;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.realm.CustomUserNamePasswordToken;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.ConfigUtil;
import net.mingsoft.basic.util.SpringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class SecretUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(SecretUtil.class);
    public static final String SECRET = "secret";
    public static final String MANAGER_ID = "managerId";
    public static final String PEOPLE_ID = "peopleId";

    public static void addSecretParam(Map param) {
        if (!SecretUtil.isEnableSecret()) {
            return;
        }
        param.put(SECRET, "");
        param.put(MANAGER_ID, "");
        param.put(PEOPLE_ID, "");
        Subject subject = SecurityUtils.getSubject();
        if (subject == null || !subject.isAuthenticated()) {
            return;
        }
        ManagerEntity manager = BasicUtil.getManager();
        JdbcTemplate jdbcTemplate = SpringUtil.getBean(JdbcTemplate.class);
        if (manager != null) {
            String managerSecret = (String)jdbcTemplate.queryForObject("SELECT _SECRET FROM MANAGER WHERE ID = ?", String.class, new Object[]{manager.getId()});
            param.put(SECRET, managerSecret);
            param.put(MANAGER_ID, manager.getId());
        } else if (subject.hasRole(CustomUserNamePasswordToken.AuthType.PEOPLE.name())) {
            try {
                Map peopleMap = (Map)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)subject.getPrincipal()), Map.class);
                String peopleId = peopleMap.get("id").toString();
                if (StringUtils.isNotBlank((CharSequence)peopleId)) {
                    String peopleSecret = (String)jdbcTemplate.queryForObject("SELECT _SECRET FROM PEOPLE WHERE ID = ?", String.class, new Object[]{peopleId});
                    param.put(SECRET, peopleSecret);
                    param.put(PEOPLE_ID, SecretUtil.getPeopleCreateBy(peopleId));
                }
            }
            catch (Exception e) {
                LOG.error("\u89e3\u6790 people principal \u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static boolean isEnableSecret() {
        return ConfigUtil.getBoolean("\u5206\u4fdd\u914d\u7f6e", "secretEnable", false);
    }

    public static String getPeopleCreateBy(String id) {
        return "u_" + id;
    }
}

