/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.util;

import cn.hutool.core.io.FileMagicNumber;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import jakarta.validation.constraints.NotNull;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    private static String fileSuffix = "[/|\\\\]upload.*?\\.(rmvb|mpga|mpg4|mpeg|docx|xlsx|pptx|jpeg|[a-z]{3})";

    public static void del(String json) {
        Pattern pattern = Pattern.compile(fileSuffix);
        Matcher matcher = pattern.matcher(json);
        while (matcher.find()) {
            try {
                FileUtils.forceDelete((File)new File(BasicUtil.getRealPath(matcher.group())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void del(List<?> list) {
        String json = "";
        for (Object entity : list) {
            json = JSONUtil.toJsonStr(entity);
            FileUtil.del(json);
        }
    }

    public static void del(BaseEntity entity) {
        String json = JSONUtil.toJsonStr((Object)entity);
        FileUtil.del(json);
    }

    public static String readJarFile(String path) {
        try {
            ClassPathResource classPathResource = new ClassPathResource(path);
            return IOUtils.toString((InputStream)classPathResource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MultipartFile remoteUrlToMultipartFile(String url, String defaultSuffix) {
        if (StrUtil.isBlank((CharSequence)url)) {
            return null;
        }
        byte[] bytes = HttpUtil.downloadBytes((String)url);
        if (bytes == null) {
            return null;
        }
        String suffix = FileMagicNumber.getMagicNumber((byte[])bytes).getExtension();
        suffix = StrUtil.isNotBlank((CharSequence)suffix) ? suffix : defaultSuffix;
        return FileUtil.bytesToMultipartFile(bytes, suffix);
    }

    public static MultipartFile bytesToMultipartFile(byte[] bytes, String defaultSuffix) {
        FileMagicNumber fileMagicNumber = FileMagicNumber.getMagicNumber((byte[])bytes);
        String suffix = fileMagicNumber.getExtension();
        suffix = StrUtil.isNotBlank((CharSequence)suffix) ? suffix : defaultSuffix;
        String fileName = IdUtil.getSnowflake().nextId() + "." + suffix;
        return FileUtil.bytesToMultipartFile(bytes, fileName, fileMagicNumber.getMimeType());
    }

    public static MultipartFile bytesToMultipartFile(byte[] bytes, String fileName, String contentType) {
        return new BytesToMultipartFile(bytes, fileName, contentType);
    }

    private static class BytesToMultipartFile
    implements MultipartFile {
        private final byte[] bytes;
        private final String fileName;
        private final String contentType;

        public BytesToMultipartFile(byte[] bytes, String fileName, String contentType) {
            this.bytes = bytes;
            this.fileName = fileName;
            this.contentType = contentType;
        }

        @NotNull
        public String getName() {
            return this.fileName;
        }

        @NotNull
        public String getOriginalFilename() {
            return this.fileName;
        }

        @NotNull
        public String getContentType() {
            return this.contentType;
        }

        public boolean isEmpty() {
            return this.bytes == null || this.bytes.length == 0;
        }

        public long getSize() {
            return this.bytes.length;
        }

        @NotNull
        public byte[] getBytes() {
            return this.bytes;
        }

        @NotNull
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public void transferTo(@NotNull File dest) throws IOException {
            try (FileOutputStream os = new FileOutputStream(dest);){
                ((OutputStream)os).write(this.bytes);
            }
        }
    }
}

