/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.realm;

import java.util.List;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.constant.e.ManagerAdminEnum;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.realm.BaseAuthRealm;
import net.mingsoft.basic.realm.CustomUserNamePasswordToken;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class ManagerAuthRealm
extends BaseAuthRealm {
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IModelBiz modelBiz;

    public ManagerAuthRealm() {
        super.setName(((Object)((Object)this)).getClass().getName());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        ManagerEntity newManager = new ManagerEntity();
        newManager.setManagerName(upToken.getUsername());
        ManagerEntity manager = (ManagerEntity)((Object)this.managerBiz.getEntity(newManager));
        if (manager != null) {
            return new SimpleAuthenticationInfo((Object)manager, (Object)manager.getManagerPassword(), this.getName());
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        ManagerEntity newManager = (ManagerEntity)((Object)principalCollection.fromRealm(this.getName()).iterator().next());
        ManagerEntity manager = (ManagerEntity)((Object)this.managerBiz.getEntity(newManager));
        if (null == manager) {
            return null;
        }
        SimpleAuthorizationInfo result = new SimpleAuthorizationInfo();
        result.addRole(CustomUserNamePasswordToken.AuthType.MANAGER.toString());
        List<ModelEntity> models = ManagerAdminEnum.SUPER.toString().equals(manager.getManagerAdmin()) ? this.modelBiz.list() : this.modelBiz.queryModelByRoleId(manager.getRoleId());
        for (ModelEntity e : models) {
            ModelEntity me = e;
            if (StringUtils.isEmpty((CharSequence)me.getModelUrl())) continue;
            result.addStringPermission(me.getModelUrl());
        }
        return result;
    }

    public boolean supports(AuthenticationToken token) {
        if (token instanceof CustomUserNamePasswordToken) {
            CustomUserNamePasswordToken customUserNamePasswordToken = (CustomUserNamePasswordToken)token;
            return customUserNamePasswordToken.getAuthType() == CustomUserNamePasswordToken.AuthType.MANAGER;
        }
        return false;
    }

    public boolean isPermitted(PrincipalCollection principals, String permission) {
        if (!this.isManagerPrincipals(principals)) {
            return false;
        }
        ManagerEntity manager = (ManagerEntity)((Object)principals.getPrimaryPrincipal());
        return ManagerAdminEnum.SUPER.toString().equalsIgnoreCase(manager.getManagerAdmin()) || super.isPermitted(principals, permission);
    }

    public boolean hasRole(PrincipalCollection principals, String roleIdentifier) {
        if (this.isManagerPrincipals(principals) && CustomUserNamePasswordToken.AuthType.MANAGER.toString().equals(roleIdentifier)) {
            ManagerEntity manager = (ManagerEntity)((Object)principals.getPrimaryPrincipal());
            return ManagerAdminEnum.SUPER.toString().equalsIgnoreCase(manager.getManagerAdmin()) || super.hasRole(principals, roleIdentifier);
        }
        return false;
    }

    private boolean isManagerPrincipals(PrincipalCollection principals) {
        return principals.getPrimaryPrincipal() instanceof ManagerEntity;
    }
}

