/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.exception;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.hutool.json.JSONUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.util.BundleUtil;
import net.mingsoft.basic.biz.ILogBiz;
import net.mingsoft.basic.entity.LogEntity;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.CalculationUtil;
import net.mingsoft.basic.util.ConfigUtil;
import net.mingsoft.basic.util.IpUtils;
import net.mingsoft.basic.util.SpringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.tomcat.util.http.fileupload.impl.SizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;
import org.springframework.web.servlet.resource.NoResourceFoundException;

@ControllerAdvice
public class GlobalExceptionResolver
extends DefaultHandlerExceptionResolver {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private ILogBiz logBiz;

    @ExceptionHandler(value={BusinessException.class})
    @Deprecated
    public ModelAndView handleBusinessException(HttpServletRequest request, HttpServletResponse response, BusinessException e) {
        this.LOG.debug("handleBusinessException");
        response.setStatus(e.getCode().value());
        return this.render(request, response, ResultData.build().code(e.getCode()).data(e.getData()).msg(e.getMsg()), e);
    }

    @ExceptionHandler(value={net.mingsoft.base.exception.BusinessException.class})
    public ModelAndView handleBusinessException(HttpServletRequest request, HttpServletResponse response, net.mingsoft.base.exception.BusinessException e) {
        this.LOG.debug("handleBusinessException");
        response.setStatus(e.getCode().value());
        return this.render(request, response, ResultData.build().code(e.getCode()).data(e.getData()).msg(e.getMsg()), (Exception)((Object)e));
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        this.LOG.debug("handleException");
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.INTERNAL_SERVER_ERROR), e);
    }

    @ExceptionHandler(value={BadSqlGrammarException.class})
    public ModelAndView handleSqlException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        this.LOG.debug("handleSqlException");
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.INTERNAL_SERVER_ERROR).msg("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\uff01"), e);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ModelAndView handleNoHandlerFoundException(HttpServletRequest request, HttpServletResponse response, NoHandlerFoundException e) {
        this.LOG.debug("handleNoHandlerFoundException");
        return this.render(request, response, ResultData.build().code(HttpStatus.NOT_FOUND).msg("page 404"), (Exception)e);
    }

    @ExceptionHandler(value={NoResourceFoundException.class})
    public ModelAndView handleNoResourceFoundException(HttpServletRequest request, HttpServletResponse response, NoResourceFoundException e) {
        this.LOG.debug("handleNoResourceFoundException");
        return this.render(request, response, ResultData.build().code(HttpStatus.NOT_FOUND).msg("\u8d44\u6e90\u4e0d\u5b58\u5728"), (Exception)e);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ModelAndView handleMissingServletRequestParameterException(HttpServletRequest request, HttpServletResponse response, MissingServletRequestParameterException e) {
        this.LOG.debug("handleMissingServletRequestParameterException");
        return this.render(request, response, ResultData.build().code(HttpStatus.BAD_REQUEST).msg("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38"), (Exception)e);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ModelAndView uploadException(HttpServletRequest request, HttpServletResponse response, MaxUploadSizeExceededException e) throws IOException {
        this.LOG.debug("MaxUploadSizeExceededException");
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        long maxFileSize = ((SizeException)e.getCause().getCause()).getPermittedSize();
        return this.render(request, response, ResultData.build().code(HttpStatus.INTERNAL_SERVER_ERROR).msg(BundleUtil.getString((String)"net.mingsoft.basic.resources.resources", (String)"upload.max.size", (String[])new String[]{CalculationUtil.convertSpaceUnit(maxFileSize / 1024L)})), (Exception)e);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ModelAndView handleHttpRequestMethodNotSupportedException(HttpServletRequest request, HttpServletResponse response, HttpRequestMethodNotSupportedException e) {
        this.LOG.debug("handleHttpRequestMethodNotSupportedException");
        return this.render(request, response, ResultData.build().code(HttpStatus.METHOD_NOT_ALLOWED).msg("\u8bf7\u6c42\u65b9\u6cd5\u7c7b\u578b\u9519\u8bef"), (Exception)e);
    }

    @ExceptionHandler(value={BindException.class})
    public ModelAndView handleValidExceptionHandler(HttpServletRequest request, HttpServletResponse response, BindException e) {
        this.LOG.debug("handleValidExceptionHandler");
        StringBuilder message = new StringBuilder();
        List fieldErrors = e.getBindingResult().getFieldErrors();
        for (FieldError error : fieldErrors) {
            message.append(error.getField()).append(error.getDefaultMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return this.render(request, response, ResultData.build().code(HttpStatus.NOT_ACCEPTABLE).msg(message.toString()), (Exception)e);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public ModelAndView handleUnauthorizedException(HttpServletRequest request, HttpServletResponse response, UnauthorizedException e) {
        this.LOG.debug("handleUnauthorizedException");
        return this.render(request, response, ResultData.build().code(HttpStatus.UNAUTHORIZED).msg("\u65e0\u8bbf\u95ee\u6743\u9650!"), (Exception)e);
    }

    @ExceptionHandler(value={LockedAccountException.class})
    public ModelAndView handleLockedAccountException(HttpServletRequest request, HttpServletResponse response, LockedAccountException e) {
        this.LOG.debug("handleLockedAccountException");
        response.setStatus(HttpStatus.LOCKED.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.LOCKED).msg(e.getMessage()), (Exception)e);
    }

    @ExceptionHandler(value={IncorrectCredentialsException.class})
    public ModelAndView handleIncorrectCredentialsException(HttpServletRequest request, HttpServletResponse response, IncorrectCredentialsException e) {
        this.LOG.debug("IncorrectCredentialsException");
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.INTERNAL_SERVER_ERROR).msg("\u7ba1\u7406\u5458\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef"), (Exception)e);
    }

    @ExceptionHandler(value={UnknownAccountException.class})
    public ModelAndView handleUnknownAccountException(HttpServletRequest request, HttpServletResponse response, UnknownAccountException e) {
        this.LOG.debug("UnknownAccountException");
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.BAD_REQUEST).msg("\u5f53\u524d\u7ad9\u70b9\u4e0b\u6b64\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728!"), (Exception)e);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public ModelAndView handleAuthenticationException(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) {
        this.LOG.debug("AuthenticationException");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.UNAUTHORIZED).msg("\u8eab\u4efd\u8ba4\u8bc1\u5f02\u5e38"), (Exception)e);
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public ModelAndView handleAuthorizationException(HttpServletRequest request, HttpServletResponse response, AuthorizationException e) {
        this.LOG.debug("AuthorizationException");
        return this.render(request, response, ResultData.build().code(HttpStatus.UNAUTHORIZED).msg("\u6388\u6743\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55"), (Exception)e);
    }

    @ExceptionHandler(value={CredentialsException.class})
    public ModelAndView handleCredentialsException(HttpServletRequest request, HttpServletResponse response, CredentialsException e) {
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.UNAUTHORIZED).msg("&#x51ED;&#x8BC1;&#x5F02;&#x5E38;"), (Exception)e);
    }

    @ExceptionHandler(value={ExpiredSessionException.class})
    public ModelAndView handleExpiredSessionException(HttpServletRequest request, HttpServletResponse response, ExpiredSessionException e) {
        this.LOG.debug("ExpiredSessionException", (Throwable)e);
        response.setStatus(HttpStatus.GATEWAY_TIMEOUT.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.GATEWAY_TIMEOUT), (Exception)e);
    }

    @ExceptionHandler(value={SQLException.class})
    public ModelAndView handleSQLException(HttpServletRequest request, HttpServletResponse response, SQLException e) {
        this.LOG.debug("SQLException", (Throwable)e);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.INTERNAL_SERVER_ERROR).msg("\u7cfb\u7edf\u5f02\u5e38,\u8bf7\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7"), e);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ModelAndView handleHttpMediaTypeNotAcceptableException(HttpServletRequest request, HttpServletResponse response, HttpMediaTypeNotAcceptableException e) {
        this.LOG.debug("HttpMediaTypeNotAcceptableException", (Throwable)e);
        Map<String, Object> ipConfigData = ConfigUtil.getEntityMap("ip\u9ed1\u767d\u540d\u5355\u914d\u7f6e");
        if (ipConfigData == null) {
            return this.render(request, response, ResultData.build().code(HttpStatus.NOT_ACCEPTABLE).msg("\u8bf7\u6c42\u7c7b\u578b\u9519\u8bef"), (Exception)e);
        }
        Map headersMap = JakartaServletUtil.getHeadersMap((HttpServletRequest)request);
        String headers = headersMap.toString();
        if (headers.contains("${jndi") || headers.contains("${")) {
            HashMap configData = (HashMap)JSONUtil.toBean((String)ipConfigData.get("configData").toString(), HashMap.class);
            String blackList = String.valueOf(configData.get("blackList"));
            String ip = BasicUtil.getIp();
            blackList = StringUtils.isBlank((CharSequence)blackList) ? ip : blackList.concat(",").concat(ip);
            this.LOG.warn("ip: {} \u6076\u610f\u6ce8\u5165", (Object)ip);
            configData.put("blackList", blackList);
            String configDataJson = JSONUtil.toJsonStr((Object)configData);
            ipConfigData.put("configData", configDataJson);
            ConfigUtil.saveOrUpdate(ipConfigData);
            this.LOG.warn("ip: {} \u6076\u610f\u6ce8\u5165\uff0c\u6dfb\u52a0\u5230ip\u9ed1\u767d\u540d\u5355\u914d\u7f6e\u7f13\u5b58\u4e2d", (Object)ip);
            JdbcTemplate jdbcTemplate = SpringUtil.getBean(JdbcTemplate.class);
            jdbcTemplate.update("UPDATE MDIY_CONFIG SET CONFIG_DATA = ? WHERE MODEL_ID = ?", new Object[]{configDataJson, ipConfigData.get("modelId")});
            this.LOG.warn("ip: {} \u6076\u610f\u6ce8\u5165\uff0c\u6dfb\u52a0\u5230\u6570\u636e\u5e93\u4e2d", (Object)ip);
        }
        response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.NOT_ACCEPTABLE).msg("\u975e\u6cd5\u8bf7\u6c42\u64cd\u4f5c\uff01"), (Exception)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelAndView render(HttpServletRequest request, HttpServletResponse response, ResultData resultData, Exception e) {
        String originUrl = (String)request.getAttribute("jakarta.servlet.forward.request_uri");
        originUrl = StringUtils.isBlank((CharSequence)originUrl) ? request.getRequestURI() : originUrl;
        this.LOG.debug("url: {}, ip: {}", (Object)originUrl, (Object)BasicUtil.getIp());
        if (e instanceof NoResourceFoundException) {
            this.LOG.warn(e.getMessage());
            if (BasicUtil.isAjaxRequest(request)) {
                try {
                    response.setContentType("application/json;charset=UTF-8");
                    response.setStatus(resultData.getCode());
                    PrintWriter writer = response.getWriter();
                    writer.write(JSONUtil.toJsonStr((Object)resultData));
                    writer.flush();
                    writer.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return null;
            }
            return new ModelAndView("/error/index", (Map)resultData);
        }
        e.printStackTrace();
        String contextPath = request.getServletContext().getContextPath();
        request.setAttribute("base", (Object)contextPath);
        String requestPath = request.getServletPath();
        if (StringUtils.isBlank((CharSequence)resultData.getMsg())) {
            resultData.msg(BundleUtil.getString((String)"net.mingsoft.basic.resources.resources", (String)"sys.err", (String[])new String[0]));
        }
        if (!response.isCommitted()) {
            if (BasicUtil.isAjaxRequest(request)) {
                try {
                    response.setContentType("application/json;charset=UTF-8");
                    response.setStatus(resultData.getCode());
                    PrintWriter writer = response.getWriter();
                    writer.write(JSONUtil.toJsonStr((Object)resultData));
                    writer.flush();
                    writer.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    this.saveExceptionLog(requestPath, e);
                }
            } else {
                this.saveExceptionLog(requestPath, e);
                response.setStatus(resultData.getCode());
                return new ModelAndView("/error/index", (Map)resultData);
            }
        }
        return null;
    }

    private void saveExceptionLog(String requestPath, Exception e) {
        List<StackTraceElement> stackElements = new ArrayList<StackTraceElement>();
        stackElements.addAll(Arrays.asList(e.getStackTrace()));
        LogEntity log = new LogEntity();
        log.setLogResult(e.getMessage() == null ? e.toString() : e.getMessage());
        stackElements = this.getAllStackTrace(log, stackElements, e.getCause());
        List stackList = stackElements.stream().filter(s -> s.getClassName().contains("net.mingsoft")).map(StackTraceElement::getFileName).filter(fileName -> Objects.requireNonNull(fileName).contains(".java")).collect(Collectors.toList());
        List className = stackElements.stream().filter(s -> s.getClassName().contains("net.mingsoft")).filter(fileName -> Objects.requireNonNull(fileName.getFileName()).contains(".java")).map(StackTraceElement::getClassName).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(className) && className.size() > 1) {
            log.setLogMethod((String)className.get(0));
        } else {
            log.setLogMethod(e.getStackTrace()[0].getClassName());
        }
        if (CollUtil.isNotEmpty(stackList) && className.size() > 1) {
            log.setLogTitle((String)stackList.get(0));
        } else {
            log.setLogMethod(e.getStackTrace()[0].getFileName());
        }
        log.setLogUrl(requestPath);
        log.setLogErrorMsg(stackElements.toString());
        log.setLogLocation(IpUtils.getRealAddressByIp(BasicUtil.getIp()));
        log.setCreateDate(new Date());
        log.setLogBusinessType("error");
        log.setLogStatus("error");
        if (BasicUtil.getManager() != null) {
            log.setLogUser(BasicUtil.getManager().getManagerName());
        }
        log.setLogIp(BasicUtil.getIp());
        this.logBiz.save((Object)log);
        String client = "PC";
        if (BasicUtil.isMobileDevice()) {
            client = "\u79fb\u52a8\u7aef";
        }
        if (BasicUtil.isWechatBrowser()) {
            client = "\u5fae\u4fe1";
        }
        if (!e.getMessage().equalsIgnoreCase("\u8bf7\u91cd\u65b0\u767b\u9646")) {
            HttpServletRequest request = SpringUtil.getRequest();
            String originUrl = "\u65e0";
            if (request != null) {
                originUrl = (String)request.getAttribute("jakarta.servlet.forward.request_uri");
                originUrl = StringUtils.isBlank((CharSequence)originUrl) ? request.getRequestURI() : originUrl;
            }
            this.LOG.error("\n co GlobalExceptionResolver \u63d0\u793a \n \u6765\u6e90{} \n  \u8bf7\u6c42\u5730\u5740 {} \n \u8bbf\u5ba2IP {} \n   \u5f02\u5e38\u539f\u56e0{} \n \u5f02\u5e38\u4ee3\u7801\u4ee3\u7801\u4f4d\u7f6e {}", new Object[]{client, originUrl, BasicUtil.getIp() + IpUtils.getRealAddressByIp(BasicUtil.getIp()), e.getMessage() == null ? e.toString() : e.getMessage(), log.getLogErrorMsg()});
        }
    }

    private List<StackTraceElement> getAllStackTrace(LogEntity log, List<StackTraceElement> traceElementList, Throwable t) {
        if (t != null) {
            if (StringUtils.isBlank((CharSequence)log.getLogResult())) {
                log.setLogResult(t.getMessage());
            }
            traceElementList.addAll(0, Arrays.asList(t.getStackTrace()));
            this.getAllStackTrace(log, traceElementList, t.getCause());
        }
        return traceElementList;
    }
}

