/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action.web;

import cn.hutool.core.bean.BeanUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.strategy.ILoginStrategy;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.config.MSProperties;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u524d\u7aef-\u57fa\u7840\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}"})
public class LoginAction
extends BaseAction {
    @Autowired
    private IAppBiz appBiz;
    @Autowired
    private ILoginStrategy loginStrategy;
    @Autowired
    private IManagerBiz managerBiz;

    @Operation(summary="\u52a0\u8f7d\u7ba1\u7406\u5458\u767b\u5f55\u754c\u9762")
    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request) {
        String managerPath = MSProperties.manager.path;
        Subject currentSubject = SecurityUtils.getSubject();
        if (BasicUtil.getManager() != null && currentSubject.isAuthenticated()) {
            return "redirect:" + managerPath + "/index.do";
        }
        return "/login";
    }

    @Operation(summary="\u9a8c\u8bc1\u767b\u5f55")
    @Parameters(value={@Parameter(name="managerName", description="\u5e10\u53f7", required=true, in=ParameterIn.QUERY), @Parameter(name="managerPassword", description="\u5bc6\u7801", required=true, in=ParameterIn.QUERY)})
    @PostMapping(value={"/login"})
    @ResponseBody
    public ResultData login(@ModelAttribute @Parameter(hidden=true) ManagerEntity manager, HttpServletRequest request, HttpServletResponse response) {
        this.LOG.debug("basic checkLogin");
        if (!this.checkRandCode()) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("rand.code")}));
        }
        if (this.loginStrategy.login(manager).booleanValue()) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("sessionId", SecurityUtils.getSubject().getSession().getId());
            return ResultData.build().success().data(map);
        }
        return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager.name.or.password")}));
    }

    @Operation(summary="\u9a8c\u8bc1\u5f53\u524d\u662f\u5426\u5df2\u7ecf\u767b\u5f55\u7ba1\u7406\u5458")
    @GetMapping(value={"/checkLogin"})
    @ResponseBody
    public ResultData checkLogin(HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity manager = BasicUtil.getManager();
        if (manager == null || !SecurityUtils.getSubject().isAuthenticated()) {
            return ResultData.build().error("\u7ba1\u7406\u5458\u5df2\u5931\u6548!");
        }
        ManagerEntity managerEntity = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)manager.getId())));
        if (managerEntity != null) {
            managerEntity.setManagerPassword("");
        }
        Map stringObjectMap = BeanUtil.beanToMap((Object)((Object)managerEntity), (String[])new String[0]);
        stringObjectMap.put("sessionId", SecurityUtils.getSubject().getSession().getId());
        return ResultData.build().success((Object)stringObjectMap);
    }
}

