/**
 * Copyright (c) 2012-present 铭软科技(mingsoft.net)
 * 本软件及相关文档文件（以下简称“软件”）的版权归 铭软科技 所有
 * 遵循 铭软科技《服务协议》中的《保密条款》
 */








package net.mingsoft.basic.aop;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;

/**
 * 拦截保存更新方法，设置操作人和时间
 * @author by Administrator
 * @Description TODO
 * @date 2019/11/12 10:14
 */
@Component
@Aspect
public class SaveOrUpdateAop extends BaseAop {

    @Pointcut("execution(* net.mingsoft..*Action.save(..))")
    public void save() {

    }

    @Pointcut("execution(* net.mingsoft..*Action.update(..))")
    public void update() {
    }

    @Before("save()")
    public void save(JoinPoint jp) {
        Date date = new Date();
        // 截断毫秒值，避免毫秒值大于500时，数据库级别秒值加1
        setField(jp, "createDate", DateUtil.beginOfSecond(date));
        setField(jp, "updateDate", DateUtil.beginOfSecond(date));
        ManagerEntity manager = BasicUtil.getManager();
        if (manager != null) {
            setField(jp, "createBy", manager.getId());
        }

    }


    @Before("update()")
    public void update(JoinPoint jp) {
        // 截断毫秒值，避免毫秒值大于500时，数据库级别秒值加1
        setField(jp, "updateDate", DateUtil.beginOfSecond(new Date()));
        ManagerEntity manager = BasicUtil.getManager();
        if (manager != null) {
            setField(jp, "updateBy", manager.getId());
        }
    }


    /**
     * 设置字段值
     * @param jp 切点
     * @param fieldName 字段名称
     * @param fieldValue 字段设置的值
     */
    private void setField(JoinPoint jp, String fieldName, Object fieldValue) {
        try {
            Object[] objs = jp.getArgs();
            if (objs.length == 0 || ObjectUtil.isNull(objs[0])) {
                return;
            }

            Object target = objs[0];

            // 先判断是不是 List<实体>
            if (target instanceof List<?> list) {
                if (list.isEmpty()) {
                    return;
                }
                // 遍历 List 中的每个元素
                for (Object obj : list) {
                    if (obj != null) {
                        setFieldByObject(obj, fieldName, fieldValue);
                    }
                }
            }
            else {
                // 处理单个实体对象
                setFieldByObject(target, fieldName, fieldValue);
            }
        } catch (Exception e) {
            LOG.error("Aop错误：", e);
        }
    }

    /**
     * 通过对象设置字段值
     * @param obj 需要设置字段值的对象
     * @param fieldName 字段名称
     * @param fieldValue 字段值
     * @throws IllegalAccessException 访问权限异常
     */
    private void setFieldByObject(Object obj, String fieldName, Object fieldValue) throws IllegalAccessException {
        //获取对象所有字段
        Field[] allFields = BasicUtil.getAllFields(obj);
        for (Field field : allFields) {
            //判断是否存在
            if (fieldName.equals(field.getName())) {
                field.setAccessible(true);
                field.set(obj, fieldValue);
                // 找到就赋值停止循环操作
                break;
            }
        }
    }

}
