/**
 * Copyright (c) 2012-present 铭软科技(mingsoft.net)
 * 本软件及相关文档文件（以下简称“软件”）的版权归 铭软科技 所有
 * 遵循 铭软科技《服务协议》中的《保密条款》
 */




package net.mingsoft.basic.action.web;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 网站基本信息控制层
 */
@Tag(name = "后端-基础接口")
@Controller("basicAppAction")
@RequestMapping("/basic/app")
public class AppAction extends BaseAction {

    /**
     * appBiz业务层的注入
     */
    @Autowired
    private IAppBiz appBiz;

    /**
     * 获取站点信息
     *
     * @return 返回站点信息
     */
    @Operation(summary =  "获取站点信息")
    @GetMapping(value = "/get")
    @ResponseBody
    public ResultData get() {

        // 是否战群环境下,不是就获取数据库中第一个站点返回
        AppEntity app = BasicUtil.getWebsiteApp();
        if (ObjectUtil.isNull(app)) {
            // 获取app表中的第一条数据
            app = appBiz.getFirstApp();
        }

        // 获取站点基础信息
        return ResultData.build().success(BasicUtil.putter(app, "appName",
                "appUrl",
                "appCopyright",
                "appLogo"));

    }

}
