/**
 * Copyright (c) 2012-present 铭软科技(mingsoft.net)
 * 本软件及相关文档文件（以下简称“软件”）的版权归 铭软科技 所有
 * 遵循 铭软科技《服务协议》中的《保密条款》
 */

package net.mingsoft.basic.util;

import cn.hutool.json.JSONUtil;
import net.mingsoft.basic.entity.ManagerEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.Map;

/**
 * 密级条件添加工具类
 */
public class SecretUtil {

    /**
     * 密级值
     */
    public static final String SECRET = "secret";

    /**
     * 管理员id
     */
    public static final String MANAGER_ID = "managerId";

    /**
     * 会员id
     */
    public static final String PEOPLE_ID = "peopleId";


    /**
     * 添加密级参数，如果同时登录管理员和会员，那么拥有的密级权限叠加
     * eg ： managerSecret: 1,2  peopleSecret: 1,3 => secret: 1,2,3
     */
    public static void addSecretParam(Map param){
        if (!isEnableSecret()){
            return;
        }

        param.put(SECRET, "");
        param.put(MANAGER_ID, "");
        param.put(PEOPLE_ID, "");

        ManagerEntity manager = BasicUtil.getManager();
        Object peopleSession = BasicUtil.getSession("people_session");
        JdbcTemplate jdbcTemplate = SpringUtil.getBean(JdbcTemplate.class);
        if (manager != null){
            // 获取当前登录管理员的密级值
            String managerSecret = jdbcTemplate.queryForObject("SELECT _SECRET FROM MANAGER WHERE ID = ?", String.class,manager.getId());
            param.put(SECRET, managerSecret);
            param.put(MANAGER_ID, manager.getId());
        }
        if (peopleSession != null){
            Map map = JSONUtil.toBean(JSONUtil.toJsonStr(peopleSession), Map.class);
            String id = map.get("id").toString();
            // 获取当前登录会员的密级值
            String peopleSecret = jdbcTemplate.queryForObject("SELECT _SECRET FROM PEOPLE WHERE ID = ?", String.class,id);
            String secret = param.get(SECRET).toString();
            // 管理员密级值和会员密级值叠加
            if (StringUtils.isNotBlank(secret)){
                param.put(SECRET, secret + "," + peopleSecret);
            } else {
                param.put(SECRET, peopleSecret);
            }
            param.put(PEOPLE_ID, getPeopleCreateBy(id));
        }
    }

    /**
     * 是否启用密级
     */
    public static boolean isEnableSecret(){
        return ConfigUtil.getBoolean("分保配置","secretEnable",false);
    }


    /**
     * 获取会员创建人
     * @param id 会员id
     */
    public static String getPeopleCreateBy(String id) {
        return "u_"+id;
    }

}
