/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.biz.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.bean.RoleBean;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.dao.IRoleDao;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.RoleEntity;
import net.mingsoft.basic.entity.RoleModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="roleBiz")
@Transactional
public class RoleBizImpl
extends BaseBizImpl<IRoleDao, RoleEntity>
implements IRoleBiz {
    @Autowired
    private IRoleDao roleDao;
    @Autowired
    private IRoleModelBiz roleModelBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IManagerBiz managerBiz;

    public IBaseDao getDao() {
        return this.roleDao;
    }

    @Override
    public boolean saveOrUpdateRole(RoleBean role) {
        RoleBean oldRole = new RoleBean();
        oldRole.setRoleName(role.getRoleName());
        oldRole = (RoleBean)((Object)this.roleDao.getByEntity(oldRole));
        if (StringUtils.isNotEmpty((CharSequence)role.getId())) {
            if (oldRole != null && !oldRole.getId().equals(role.getId())) {
                return false;
            }
            this.roleDao.updateEntity(role);
        } else {
            if (oldRole != null) {
                return false;
            }
            this.save((Object)role);
            this.roleDao.updateCache();
        }
        ArrayList<RoleModelEntity> roleModelList = new ArrayList<RoleModelEntity>();
        if (!StringUtils.isEmpty((CharSequence)role.getIds())) {
            for (String id : role.getIds().split(",")) {
                RoleModelEntity roleModel = new RoleModelEntity();
                roleModel.setRoleId(Integer.parseInt(role.getId()));
                roleModel.setModelId(Integer.parseInt(id));
                roleModelList.add(roleModel);
            }
            this.roleModelBiz.deleteEntity(Integer.parseInt(role.getId()));
            this.modelBiz.updateCache();
            this.roleModelBiz.saveBatch(roleModelList, roleModelList.size());
        } else {
            this.roleModelBiz.deleteEntity(Integer.parseInt(role.getId()));
        }
        return true;
    }

    @Override
    public boolean deleteRoleByRoles(List<RoleEntity> roles, ManagerEntity managerSession) {
        List roleIdList = roles.stream().map(BaseEntity::getId).collect(Collectors.toList());
        int before = roleIdList.size();
        List managerRoleIds = Arrays.stream(managerSession.getRoleIds().split(",")).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RoleEntity::getNotDel, (Object)1);
        List notDelRoles = super.list((Wrapper)wrapper);
        if (notDelRoles != null && notDelRoles.size() > 0) {
            List notDelRoleIds = notDelRoles.stream().map(BaseEntity::getId).collect(Collectors.toList());
            roleIdList.removeAll(notDelRoleIds);
        }
        roleIdList.removeAll(managerRoleIds);
        int after = roleIdList.size();
        int[] ids = roleIdList.stream().mapToInt(Integer::valueOf).toArray();
        if (ids.length > 0) {
            super.delete(ids);
            this.roleModelBiz.deleteByRoleIds(ids);
            super.updateCache();
            this.modelBiz.updateCache();
        }
        return before == after;
    }
}

