/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import java.util.HashMap;
import java.util.Map;
import net.mingsoft.basic.util.BasicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(ConfigUtil.class);
    public static Map<String, Map<String, Map<String, Object>>> CONFIG_HASH_MAP = MapUtil.newHashMap();

    public static void init(Map<String, Map<String, Map<String, Object>>> siteConfigs) {
        CONFIG_HASH_MAP.clear();
        CONFIG_HASH_MAP = siteConfigs;
    }

    public static String getString(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String getString(String configName, String key, String defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        return object.toString();
    }

    public static boolean getBoolean(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return Boolean.FALSE;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean(String.valueOf(object));
        }
        return (Boolean)object;
    }

    public static boolean getBoolean(String configName, String key, Boolean defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean(String.valueOf(object));
        }
        return (Boolean)object;
    }

    public static int getInt(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return Integer.parseInt(String.valueOf(object));
        }
        return (Integer)object;
    }

    public static int getInt(String configName, String key, int defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof String) {
            return Integer.parseInt(String.valueOf(object));
        }
        return (Integer)object;
    }

    public static long getLong(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return 0L;
        }
        if (object instanceof String) {
            return Long.parseLong(String.valueOf(object));
        }
        return (Long)object;
    }

    public static long getLong(String configName, String key, int defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof String) {
            return Long.parseLong(String.valueOf(object));
        }
        return (Long)object;
    }

    public static Object getObject(String configName, String key) {
        Map<String, Object> entity = ConfigUtil.getEntityMap(configName);
        if (entity == null) {
            return null;
        }
        HashMap map = (HashMap)JSONUtil.toBean((String)entity.get("configData").toString(), HashMap.class);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public static Map getMap(String configName) {
        Map<String, Object> entity = ConfigUtil.getEntityMap(configName);
        if (entity == null) {
            return null;
        }
        return (Map)JSONUtil.toBean((String)entity.get("configData").toString(), HashMap.class);
    }

    public static Map<String, Object> getEntityMap(String configName) {
        Map<String, Map<String, Object>> configMap = CONFIG_HASH_MAP.get("global");
        if (BasicUtil.getWebsiteApp() == null) {
            return MapUtil.isEmpty(configMap) ? null : configMap.get(configName);
        }
        Map<String, Map<String, Object>> siteConfigMap = CONFIG_HASH_MAP.get(BasicUtil.getWebsiteApp().getAppId());
        if (MapUtil.isEmpty(siteConfigMap)) {
            return configMap.get(configName);
        }
        return siteConfigMap.get(configName) != null ? siteConfigMap.get(configName) : configMap.get(configName);
    }

    public static void saveOrUpdate(Map<String, Object> entity) {
        String configName = entity.get("configName").toString();
        String appId = entity.get("appId").toString();
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        map.put(configName, entity);
        CONFIG_HASH_MAP.put(appId, map);
    }

    public static void removeEntity(String configName, String appId) {
        Map<String, Map<String, Object>> configMap = CONFIG_HASH_MAP.get(appId);
        if (MapUtil.isEmpty(configMap)) {
            return;
        }
        configMap.remove(configName);
    }

    public static void removeEntity(String configName) {
        ConfigUtil.removeEntity(configName, "global");
    }
}

