/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.crypto.SecureUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.constant.e.ManagerAdminEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u57fa\u7840\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/manager"})
public class ManagerAction
extends BaseAction {
    @Autowired
    private IManagerBiz managerBiz;

    @Hidden
    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"basic:manager:view"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/manager/index";
    }

    @Operation(summary="\u67e5\u8be2\u7ba1\u7406\u5458\u5217\u8868")
    @Parameters(value={@Parameter(name="managerName", description="\u8d26\u53f7", required=false, in=ParameterIn.QUERY), @Parameter(name="managerNickName", description="\u6635\u79f0", required=false, in=ParameterIn.QUERY)})
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"basic:manager:view"})
    @ResponseBody
    public ResultData list(@ModelAttribute @Parameter(hidden=true) ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        List managerList;
        BasicUtil.startPage();
        AppEntity websiteApp = BasicUtil.getWebsiteApp();
        if (websiteApp != null) {
            String appId = websiteApp.getAppId();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.like(StringUtils.isNotBlank((CharSequence)manager.getManagerName()), ManagerEntity::getManagerName, (Object)manager.getManagerName());
            wrapper.like(StringUtils.isNotBlank((CharSequence)manager.getManagerNickName()), ManagerEntity::getManagerNickName, (Object)manager.getManagerNickName());
            wrapper.eq(StringUtils.isNotBlank((CharSequence)manager.getRoleIds()), ManagerEntity::getRoleIds, (Object)manager.getRoleIds());
            wrapper.apply("APP_ID={0}", new Object[]{appId});
            managerList = this.managerBiz.list((Wrapper)wrapper);
        } else {
            managerList = this.managerBiz.query(manager);
        }
        List<ManagerEntity> allManager = this.managerBiz.queryAllManager(managerList);
        return ResultData.build().success((Object)BasicUtil.filter(new EUListBean(allManager, (int)BasicUtil.endPage(allManager).getTotal()), "managerPassword", "updateBy", "createBy", "del"));
    }

    @Operation(summary="\u67e5\u8be2\u7ba1\u7406\u5458\u5217\u8868,\u53bb\u6389\u5f53\u524d\u7ba1\u7406\u5458id\uff0c\u786e\u4fdd\u4e0d\u80fd\u5220\u9664\u548c\u4fee\u6539\u81ea\u5df1")
    @GetMapping(value={"/query"})
    @RequiresPermissions(value={"basic:manager:view"})
    @ResponseBody
    public ResultData query(HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        List managerList;
        ManagerEntity manager = BasicUtil.getManager();
        BasicUtil.startPage();
        AppEntity websiteApp = BasicUtil.getWebsiteApp();
        if (websiteApp != null) {
            String appId = websiteApp.getAppId();
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId);
            managerList = this.managerBiz.list((Wrapper)wrapper);
        } else {
            managerList = this.managerBiz.list();
        }
        List<ManagerEntity> allManager = this.managerBiz.queryAllManager(managerList);
        for (ManagerEntity _manager : allManager) {
            assert (manager != null);
            if (!_manager.getId().equals(manager.getId())) continue;
            _manager.setId("0");
        }
        return ResultData.build().success((Object)new EUListBean(allManager, (int)BasicUtil.endPage(allManager).getTotal()));
    }

    @Operation(summary="\u83b7\u53d6\u7ba1\u7406\u5458\u63a5\u53e3")
    @Parameter(name="id", description="\u7ba1\u7406\u5458id", required=false, in=ParameterIn.QUERY)
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"basic:manager:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @Parameter(hidden=true) ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        ManagerEntity managerEntity;
        if (StringUtils.isNotEmpty((CharSequence)manager.getId())) {
            managerEntity = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)manager.getId())));
        } else {
            ManagerEntity managerSession = BasicUtil.getManager();
            if (managerSession == null) {
                return ResultData.build().error("\u7ba1\u7406\u5458\u5df2\u5931\u6548!");
            }
            managerEntity = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)managerSession.getId())));
        }
        if (managerEntity != null) {
            managerEntity.setManagerPassword("");
        }
        return ResultData.build().success((Object)managerEntity);
    }

    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7ba1\u7406\u5458\u4fe1\u606f\u63a5\u53e3")
    @GetMapping(value={"/info"})
    @ResponseBody
    public ResultData info(HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity managerEntity = BasicUtil.getManager();
        if (managerEntity == null) {
            return ResultData.build().error("\u7ba1\u7406\u5458\u5df2\u5931\u6548!");
        }
        if ((managerEntity = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)managerEntity.getId())))) != null) {
            managerEntity.setManagerPassword("");
        }
        Map stringObjectMap = BeanUtil.beanToMap((Object)((Object)managerEntity), (String[])new String[0]);
        stringObjectMap.put("sessionId", SecurityUtils.getSubject().getSession().getId());
        return ResultData.build().success((Object)stringObjectMap);
    }

    @Operation(summary="\u4fdd\u5b58\u7ba1\u7406\u5458\u5b9e\u4f53")
    @Parameters(value={@Parameter(name="managerName", description="\u5e10\u53f7", required=true, in=ParameterIn.QUERY), @Parameter(name="managerNickName", description="\u6635\u79f0", required=true, in=ParameterIn.QUERY), @Parameter(name="managerPassword", description="\u5bc6\u7801", required=true, in=ParameterIn.QUERY), @Parameter(name="roleIds", description="\u89d2\u8272IDS", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u4fdd\u5b58\u7ba1\u7406\u5458\u5b9e\u4f53", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"basic:manager:save"})
    public ResultData save(@ModelAttribute @Parameter(hidden=true) ManagerEntity manager, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)manager.getManagerName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.name")}));
        }
        if (!StringUtil.checkLength(manager.getManagerName(), 6, 15)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.name"), "6", "15"}));
        }
        if (this.managerBiz.getManagerByManagerName(manager.getManagerName()) != null) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("manager.name")}));
        }
        if (!manager.getManagerName().matches("^[a-zA-Z0-9_]{6,15}$")) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager.name")}));
        }
        if (StringUtils.isNotBlank((CharSequence)manager.getManagerAdmin())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager")}));
        }
        manager.setManagerAdmin("");
        if (StringUtils.isBlank((CharSequence)manager.getManagerNickName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.nickname")}));
        }
        if (!StringUtil.checkLength(manager.getManagerNickName(), 1, 15)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.nickname"), "1", "15"}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getRoleIds())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.roleid")}));
        }
        if (!StringUtil.checkLength(manager.getRoleIds(), 1, 50)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.roleid"), "1", "50"}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getManagerPassword())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.password")}));
        }
        if (!StringUtil.checkLength(manager.getManagerPassword(), 6, 30)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.password"), "6", "30"}));
        }
        if (!manager.getManagerPassword().matches("(?!^(\\d+|[a-zA-Z]+|[~!@#$%^&*?]+)$)^[\\w~!@#$%^&*?]{6,30}$")) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager.password")}));
        }
        manager.setManagerPassword(SecureUtil.md5((String)manager.getManagerPassword()));
        this.managerBiz.save((Object)manager);
        this.managerBiz.updateCache();
        return ResultData.build().success((Object)manager);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u7ba1\u7406\u5458")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u7ba1\u7406\u5458", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"basic:manager:del"})
    public ResultData delete(@RequestBody List<ManagerEntity> managers, HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity manager = BasicUtil.getManager();
        Integer[] ids = new Integer[managers.size()];
        for (int i = 0; i < managers.size(); ++i) {
            ids[i] = Integer.parseInt(managers.get(i).getId());
        }
        List managerEntities = this.managerBiz.listByIds(Arrays.asList(ids));
        if (CollectionUtil.isNotEmpty(managerEntities = managerEntities.stream().filter(managerEntity -> ManagerAdminEnum.SUPER.toString().equals(managerEntity.getManagerAdmin()) || ManagerAdminEnum.SUPERADMIN.toString().equals(managerEntity.getManagerAdmin()) || manager.getId().equals(managerEntity.getId())).collect(Collectors.toList()))) {
            this.LOG.error("\u975e\u6cd5\u64cd\u4f5c\u5220\u9664\u8d85\u7ba1\u8d26\u53f7\u6216\u81ea\u5df1\u8d26\u53f7");
            return ResultData.build().error(this.getResString("fail", new String[]{this.getResString("remove")}));
        }
        this.managerBiz.removeByIds(Arrays.asList(ids));
        this.managerBiz.updateCache();
        return ResultData.build().success();
    }

    @Operation(summary="\u66f4\u65b0\u7ba1\u7406\u5458\u4fe1\u606f")
    @Parameters(value={@Parameter(name="id", description="id", required=true, in=ParameterIn.QUERY), @Parameter(name="managerNickName", description="\u6635\u79f0", required=true, in=ParameterIn.QUERY), @Parameter(name="managerPassword", description="\u5bc6\u7801", required=false, in=ParameterIn.QUERY), @Parameter(name="roleIds", description="\u89d2\u8272IDS", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u66f4\u65b0\u7ba1\u7406\u5458\u4fe1\u606f", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"basic:manager:update"})
    public ResultData update(@ModelAttribute @Parameter(hidden=true) ManagerEntity manager) {
        this.managerBiz.updateCache();
        ManagerEntity _manager = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)manager.getId())));
        if (_manager == null) {
            return ResultData.build().error(this.getResString("err.not.exist", new String[]{this.getResString("managerName")}));
        }
        if (StringUtils.isNotBlank((CharSequence)manager.getManagerAdmin())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager")}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getManagerNickName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.nickname")}));
        }
        if (!StringUtil.checkLength(manager.getManagerNickName(), 1, 15)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.nickname"), "1", "15"}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getRoleIds())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.roleid")}));
        }
        if (!StringUtil.checkLength(manager.getRoleIds(), 1, 50)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.roleid"), "1", "50"}));
        }
        if (!StringUtils.isBlank((CharSequence)manager.getManagerPassword())) {
            if (!StringUtil.checkLength(manager.getManagerPassword(), 6, 30)) {
                return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.password"), "6", "30"}));
            }
            if (!manager.getManagerPassword().matches("(?!^(\\d+|[a-zA-Z]+|[~!@#$%^&*?]+)$)^[\\w~!@#$%^&*?]{6,30}$")) {
                return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager.password")}));
            }
            manager.setManagerPassword(SecureUtil.md5((String)manager.getManagerPassword()));
        } else {
            manager.setManagerPassword(null);
        }
        manager.setManagerName(_manager.getManagerName());
        this.managerBiz.updateById((Object)manager);
        return ResultData.build().success((Object)manager);
    }
}

