/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.bean.LogBean;
import net.mingsoft.basic.biz.ILogBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.entity.LogEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u57fa\u7840\u63a5\u53e3")
@Controller(value="basicLogAction")
@RequestMapping(value={"/${ms.manager.path}/basic/log"})
public class LogAction
extends BaseAction {
    @Autowired
    private ILogBiz logBiz;

    @Hidden
    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"basic:log:view"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/log/index";
    }

    @Hidden
    @GetMapping(value={"/form"})
    @RequiresPermissions(value={"basic:log:view"})
    public String form(@ModelAttribute LogEntity log, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        return "/basic/log/form";
    }

    @Operation(summary="\u67e5\u8be2\u7cfb\u7edf\u65e5\u5fd7\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="logTitle", description="\u6807\u9898", required=false, in=ParameterIn.QUERY), @Parameter(name="logIp", description="IP", required=false, in=ParameterIn.QUERY), @Parameter(name="logMethod", description="\u8bf7\u6c42\u65b9\u6cd5", required=false, in=ParameterIn.QUERY), @Parameter(name="logRequestMethod", description="\u8bf7\u6c42\u65b9\u5f0f", required=false, in=ParameterIn.QUERY), @Parameter(name="logUrl", description="\u8bf7\u6c42\u5730\u5740", required=false, in=ParameterIn.QUERY), @Parameter(name="logStatus", description="\u8bf7\u6c42\u72b6\u6001", required=false, in=ParameterIn.QUERY), @Parameter(name="logBusinessType", description="\u4e1a\u52a1\u7c7b\u578b", required=false, in=ParameterIn.QUERY), @Parameter(name="logUserType", description="\u7528\u6237\u7c7b\u578b", required=false, in=ParameterIn.QUERY), @Parameter(name="logUser", description="\u64cd\u4f5c\u4eba\u5458", required=false, in=ParameterIn.QUERY), @Parameter(name="logLocation", description="\u6240\u5728\u5730\u533a", required=false, in=ParameterIn.QUERY), @Parameter(name="logParam", description="\u8bf7\u6c42\u53c2\u6570", required=false, in=ParameterIn.QUERY), @Parameter(name="logResult", description="\u8fd4\u56de\u53c2\u6570", required=false, in=ParameterIn.QUERY), @Parameter(name="logErrorMsg", description="\u9519\u8bef\u6d88\u606f", required=false, in=ParameterIn.QUERY), @Parameter(name="createBy", description="\u521b\u5efa\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="createDate", description="\u521b\u5efa\u65f6\u95f4", required=false, in=ParameterIn.QUERY), @Parameter(name="updateBy", description="\u4fee\u6539\u4eba", required=false, in=ParameterIn.QUERY), @Parameter(name="updateDate", description="\u4fee\u6539\u65f6\u95f4", required=false, in=ParameterIn.QUERY), @Parameter(name="del", description="\u5220\u9664\u6807\u8bb0", required=false, in=ParameterIn.QUERY), @Parameter(name="id", description="\u7f16\u53f7", required=false, in=ParameterIn.QUERY)})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    @RequiresPermissions(value={"basic:log:view"})
    public ResultData list(@ModelAttribute @Parameter(hidden=true) LogBean log, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model, BindingResult result) {
        BasicUtil.startPage();
        List logList = this.logBiz.query(log);
        return ResultData.build().success((Object)new EUListBean(logList, (int)BasicUtil.endPage(logList).getTotal()));
    }

    @Operation(summary="\u83b7\u53d6\u7cfb\u7edf\u65e5\u5fd7\u5217\u8868\u63a5\u53e3")
    @Parameter(name="id", description="\u7f16\u53f7", required=true, in=ParameterIn.QUERY)
    @GetMapping(value={"/get"})
    @ResponseBody
    @RequiresPermissions(value={"basic:log:view"})
    public ResultData get(@ModelAttribute @Parameter(hidden=true) LogEntity log, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        if (log.getId() == null) {
            return ResultData.build().error("ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        LogEntity _log = (LogEntity)((Object)this.logBiz.getById((Serializable)((Object)log.getId())));
        return ResultData.build().success((Object)_log);
    }

    @Operation(summary="\u83b7\u53d6\u65e5\u5fd7\u7c7b\u578b\u679a\u4e3e\u7c7b")
    @PostMapping(value={"/queryLogType"})
    @ResponseBody
    public ResultData queryLogType(HttpServletResponse response, HttpServletRequest request) {
        ArrayList list = new ArrayList();
        try {
            Class<?> _class = Class.forName(BusinessTypeEnum.class.getName());
            ?[] enumConstants = _class.getEnumConstants();
            Arrays.stream(enumConstants).forEach(e -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("value", e.toString().toLowerCase());
                try {
                    Method label = e.getClass().getMethod("getLabel", new Class[0]);
                    map.put("label", label.invoke(e, new Object[0]).toString());
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                list.add(map);
            });
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        return ResultData.build().success(list);
    }
}

