/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.config;

import cn.hutool.core.map.MapUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mingsoft.basic.util.ConfigUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration(value="msCacheConfig")
public class CacheConfig {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Bean
    public ApplicationRunner initializeCache() {
        return args -> {
            String sql = "select id,model_id,config_name,config_data,config_type,app_id from mdiy_config where del = 0";
            List configList = this.jdbcTemplate.queryForList(sql);
            List<Map> camelCaseConfigList = configList.stream().filter(config -> "config".equals(config.get("config_type"))).map(MapUtil::toCamelCaseMap).collect(Collectors.toList());
            HashMap<String, Map<String, Map<String, Object>>> allConfig = new HashMap<String, Map<String, Map<String, Object>>>();
            camelCaseConfigList.forEach(config -> {
                String appId = config.get("appId").toString();
                String configName = config.get("configName").toString();
                allConfig.computeIfAbsent(appId, k -> new HashMap()).computeIfAbsent(configName, k -> new HashMap()).putAll(config);
            });
            ConfigUtil.init(allConfig);
        };
    }
}

