/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.config;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class AsyncConfig {
    @Value(value="${ms.thread.core-pool-size:10}")
    private int corePoolSize;
    @Value(value="${ms.thread.max-pool-size:50}")
    private int maxPoolSize;
    @Value(value="${ms.thread.queue-capacity:1000}")
    private int queueCapacity;
    @Value(value="${ms.thread.keep-alive-seconds:300}")
    private int KeepAliveSeconds;
    @Value(value="${ms.thread.thread-name-prefix:lh-something-}")
    private String threadNamePrefix;
    @Value(value="${ms.thread.await-termination-seconds:60}")
    private int awaitTerminationSeconds;

    @Bean
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.corePoolSize);
        executor.setMaxPoolSize(this.maxPoolSize);
        executor.setQueueCapacity(this.queueCapacity);
        executor.setKeepAliveSeconds(this.KeepAliveSeconds);
        executor.setThreadNamePrefix(this.threadNamePrefix);
        executor.setAllowCoreThreadTimeOut(true);
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setAwaitTerminationSeconds(this.awaitTerminationSeconds);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

