/**
 * Copyright (c) 2012-present 铭软科技(mingsoft.net)
 * 本软件及相关文档文件（以下简称“软件”）的版权归 铭软科技 所有
 * 遵循 铭软科技《服务协议》中的《保密条款》
 */

package net.mingsoft.config;

import cn.hutool.core.map.MapUtil;
import net.mingsoft.basic.util.ConfigUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 初始化加载全部配置
 */
@Configuration("msCacheConfig")
public class CacheConfig {


    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Bean
    public ApplicationRunner initializeCache() {
        return args -> {
            String sql = "select id,model_id,config_name,config_data,config_type,app_id from mdiy_config where del = 0";

            List<Map<String, Object>> configList = jdbcTemplate.queryForList(sql);

            // 过滤出config类型 规范map的key
            List<Map<String, Object>> camelCaseConfigList = configList.stream().filter(config -> "config".equals(config.get("config_type")))
                    .map(MapUtil::toCamelCaseMap)
                    .collect(Collectors.toList());


            /**
             * 结构
             * appId:{
             *     configName: {
             *         configItem: configItemValue
             *     }
             * }
             */
            Map<String, Map<String, Map<String, Object>>> allConfig = new HashMap<>();
            camelCaseConfigList.forEach(config -> {
                String appId = config.get("appId").toString();
                String configName = config.get("configName").toString();

                allConfig.computeIfAbsent(appId, k -> new HashMap<>())
                        .computeIfAbsent(configName, k -> new HashMap<>())
                        .putAll(config);

            });
            // 配置初始化
            ConfigUtil.init(allConfig);
        };

    }
}
