/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.constant.e.CookieConstEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.MapCacheUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u57fa\u7840\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/app"})
public class AppAction
extends BaseAction {
    @Autowired
    private IAppBiz appBiz;

    @ApiIgnore
    @GetMapping(value={"/app"})
    @RequiresPermissions(value={"basic:app:view"})
    public String app(HttpServletRequest request) {
        return "/basic/app/app";
    }

    @ApiOperation(value="\u83b7\u53d6\u7ad9\u70b9\u4fe1\u606f")
    @ApiImplicitParam(name="appId", value="\u7ad9\u70b9ID", required=false, paramType="path")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get() {
        String appId = BasicUtil.getString("appId", "");
        AppEntity app = null;
        if (StringUtils.isBlank((CharSequence)appId)) {
            app = BasicUtil.getApp();
            if (app != null) {
                if (BasicUtil.getSession("appId") == null) {
                    BasicUtil.setSession("appId", (Object)app.getAppId());
                }
            } else {
                appId = (String)BasicUtil.getSession("appId");
                app = (AppEntity)((Object)this.appBiz.getById((Serializable)((Object)appId)));
            }
        } else {
            app = (AppEntity)((Object)this.appBiz.getById((Serializable)((Object)appId)));
        }
        return ResultData.build().success((Object)app);
    }

    @ApiOperation(value="\u66f4\u65b0\u7ad9\u70b9\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7ad9\u70b9id", required=true, paramType="query"), @ApiImplicitParam(name="appName", value="\u5e94\u7528\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="appDir", value="\u7f51\u7ad9\u751f\u6210\u76ee\u5f55", required=true, paramType="query"), @ApiImplicitParam(name="appStyle", value="\u7f51\u7ad9\u91c7\u7528\u7684\u6a21\u677f\u98ce\u683c", required=false, paramType="query"), @ApiImplicitParam(name="appDescription", value="\u5e94\u7528\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="appLogo", value="\u5e94\u7528logo", required=false, paramType="query"), @ApiImplicitParam(name="appKeyword", value="\u7f51\u7ad9\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="appCopyright", value="\u7f51\u7ad9\u7248\u6743\u4fe1\u606f", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @LogAnn(title="\u66f4\u65b0\u7ad9\u70b9\u4fe1\u606f", businessType=BusinessTypeEnum.UPDATE)
    @RequiresPermissions(value={"basic:app:update"})
    @ResponseBody
    public ResultData update(@ModelAttribute @ApiIgnore AppEntity app, ModelMap mode, HttpServletRequest request, HttpServletResponse response) {
        mode.clear();
        ManagerEntity managerSession = BasicUtil.getManager();
        if (managerSession == null) {
            return ResultData.build().error();
        }
        mode.addAttribute("managerSession", (Object)managerSession);
        if (!StringUtil.checkLength(app.getAppLogo() + "", 0, 4000)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("app.logo"), "0", "4000"}));
        }
        if (super.validated("app", "app_dir", app.getAppDir(), app.getId(), "id")) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("app.dir")}));
        }
        if (StringUtils.isBlank((CharSequence)app.getAppDir())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("app.dir")}));
        }
        if (!StringUtil.checkLength(app.getAppDir() + "", 0, 50)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("app.dir"), "0", "10"}));
        }
        String cookie = BasicUtil.getCookie(CookieConstEnum.PAGENO_COOKIE);
        int pageNo = 1;
        if (StringUtils.isNotBlank((CharSequence)cookie) && Integer.valueOf(cookie) > 0) {
            pageNo = Integer.valueOf(cookie);
        }
        mode.addAttribute("pageNo", (Object)pageNo);
        ResultData resultData = ResultData.build();
        if (!this.checkForm(app, resultData)) {
            return resultData;
        }
        if (StringUtils.isNotBlank((CharSequence)app.getAppLogo())) {
            app.setAppLogo(app.getAppLogo().replace("|", ""));
        }
        app.setAppUrl(BasicUtil.getUrl());
        MapCacheUtil.remove(BasicUtil.getDomain());
        this.appBiz.updateById((Object)app);
        this.appBiz.updateCache();
        return ResultData.build().success();
    }

    @ApiOperation(value="\u5237\u65b0\u7ad9\u70b9\u7f13\u5b58")
    @PostMapping(value={"/refreshCache"})
    @ResponseBody
    public ResultData refreshCache(HttpServletRequest request) {
        MapCacheUtil.remove(BasicUtil.getDomain());
        this.appBiz.updateCache();
        return ResultData.build().success();
    }

    private boolean checkForm(AppEntity app, ResultData resultData) {
        if (StringUtils.isNotBlank((CharSequence)app.getAppKeyword()) && !StringUtil.checkLength(app.getAppKeyword(), 0, 1000)) {
            resultData.error(this.getResString("err.length", new String[]{this.getResString("appKeyword"), "0", "1000"}));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)app.getAppCopyright()) && !StringUtil.checkLength(app.getAppCopyright(), 0, 1000)) {
            resultData.error(this.getResString("err.length", new String[]{this.getResString("appCopyright"), "0", "1000"}));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)app.getAppDescription()) && !StringUtil.checkLength(app.getAppDescription(), 0, 1000)) {
            resultData.error(this.getResString("err.length", new String[]{this.getResString("appDescrip"), "0", "1000"}));
            return false;
        }
        if (!StringUtil.checkLength(app.getAppName(), 1, 50)) {
            resultData.error(this.getResString("err.length", new String[]{this.getResString("appTitle"), "1", "50"}));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)app.getAppStyle()) && !StringUtil.checkLength(app.getAppStyle(), 1, 30)) {
            resultData.error(this.getResString("err.length", new String[]{this.getResString("appStyle"), "1", "30"}));
            return false;
        }
        if (ObjectUtil.isNotNull((Object)app.getAppHostUrl()) && !StringUtil.checkLength(app.getAppHostUrl(), 10, 150)) {
            resultData.error(this.getResString("err.length", new String[]{this.getResString("appUrl"), "10", "150"}));
            return false;
        }
        return true;
    }

    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u6709\u91cd\u590d\u7684\u57df\u540d")
    @ApiImplicitParam(name="appUrl", value="\u7f51\u7ad9\u57df\u540d", required=true, paramType="query")
    @GetMapping(value={"/checkUrl"})
    @ResponseBody
    public ResultData checkUrl(HttpServletRequest request) {
        if (request.getParameter("appUrl") != null) {
            if (this.appBiz.countByUrl(request.getParameter("appUrl")) > 0) {
                return ResultData.build().success();
            }
            return ResultData.build().error();
        }
        return ResultData.build().error();
    }
}

