/**
 * Copyright (c) 2012-present 铭软科技(mingsoft.net)
 * 本软件及相关文档文件（以下简称“软件”）的版权归 铭软科技 所有
 * 遵循 铭软科技《服务协议》中的《保密条款》
 */








package net.mingsoft.basic.action.web;

import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.bean.CityBean;
import net.mingsoft.basic.biz.ICityBiz;
import net.mingsoft.basic.entity.CityEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 省市县镇村数据管理控制层
 * @author 铭飞开发团队
 * @version
 * 版本号：100<br/>
 * 创建日期：2017-7-27 14:47:29<br/>
 * 历史修订：<br/>
 */
@Api(tags={"前端-基础接口"})
@Controller("webCityAction")
@RequestMapping("/basic/city")
public class CityAction extends net.mingsoft.basic.action.BaseAction{

	/**
	 * 注入省市县镇村数据业务层
	 */
	@Autowired
	private ICityBiz cityBiz;

	/**
	 * 根据上一级的id查询下一级城市数据列表集合，没有参数默认查询省集合
	 * 例 basic/city/list.do?provinceId=36
	 * @param city
	 * @return
	 */
	@ApiOperation(value = "根据id查询下一级城市数据列表集合")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "provinceId", value = "省／直辖市／自治区级id", required = false,paramType="query"),
			@ApiImplicitParam(name = "cityId", value = "市级id", required = false,paramType="query"),
			@ApiImplicitParam(name = "countyId", value = "县／区级id", required = false,paramType="query"),
			@ApiImplicitParam(name = "townId", value = "街道／镇级id", required = false,paramType="query"),
	})
	@GetMapping("/list")
	@ResponseBody
	public ResultData list(@ApiIgnore @ModelAttribute CityEntity city){
		Map<String, Object> stringObjectMap = BasicUtil.assemblyRequestMap();
		LambdaQueryWrapper<CityEntity> wrapper = new LambdaQueryWrapper<>(city);
		List<CityEntity> cityList;
		// 如果外部没有传递参数 默认只加载第一级
		if (MapUtil.isEmpty(stringObjectMap)){

			cityList = cityBiz.queryProvinceAndName(city);

			return ResultData.build().success(cityList);
		}else {
			// 根据外部传递的参数 指定查询的字段列和分组字段列 必须一致
			if (StringUtils.isNotBlank(MapUtil.getStr(stringObjectMap, "provinceId", null))){
				wrapper.select(CityEntity::getCityId,CityEntity::getCityName);
				wrapper.groupBy(CityEntity::getCityId,CityEntity::getCityName);
			}else if (StringUtils.isNotBlank(MapUtil.getStr(stringObjectMap, "cityId", null))){
				wrapper.select(CityEntity::getCountyId,CityEntity::getCountyName);
				wrapper.groupBy(CityEntity::getCountyId,CityEntity::getCountyName);
			}else if (StringUtils.isNotBlank(MapUtil.getStr(stringObjectMap, "countyId",null))){
				wrapper.select(CityEntity::getTownId,CityEntity::getTownName);
				wrapper.groupBy(CityEntity::getTownId,CityEntity::getTownName);
			}else if (StringUtils.isNotBlank(MapUtil.getStr(stringObjectMap, "townId", null))){
				wrapper.select(CityEntity::getVillageId,CityEntity::getVillageName);
				wrapper.groupBy(CityEntity::getVillageId,CityEntity::getVillageName);
			}
		}

		cityList = cityBiz.list(wrapper);
		return ResultData.build().success(cityList);
	}


	@ApiOperation(value = "获取省市县镇村数据")
	@ApiImplicitParam(name = "id", value = "城市主键编号", required = true,paramType="query")
	@GetMapping("/get")
	@ResponseBody
	public ResultData get(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model){
		if(StringUtils.isEmpty(city.getId())) {
			return ResultData.build().error( getResString("err.error", this.getResString("id")));
		}
		CityEntity _city = (CityEntity)cityBiz.getEntity(Integer.parseInt(city.getId()));
		return ResultData.build().success( _city);
	}


	@ApiOperation(value = "获取省市县镇村数据树形列表")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "level", value = "省市县层级，默认为3", required = false, paramType = "query",dataType = "int"),
		@ApiImplicitParam(name = "type", value = "结构类型，默认为tree", required = false, paramType = "query")
	})
	@GetMapping("/query")
	@ResponseBody
	@Deprecated
	public ResultData query(HttpServletResponse response,HttpServletRequest request) {
		int level = BasicUtil.getInt("level",3);//默认3级
		String type = BasicUtil.getString("type","tree"); //默认为树形结构
		List<CityBean> cityList = (List<CityBean>) cityBiz.queryForTree(level,type);
		return ResultData.build().success(cityList);
	}





}
