/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.crypto.SecureUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.constant.e.ManagerAdminEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u57fa\u7840\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/manager"})
public class ManagerAction
extends BaseAction {
    @Autowired
    private IManagerBiz managerBiz;

    @ApiIgnore
    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"basic:manager:view"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/manager/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u7ba1\u7406\u5458\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="managerName", value="\u8d26\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="managerNickName", value="\u6635\u79f0", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"basic:manager:view"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        List managerList;
        BasicUtil.startPage();
        AppEntity websiteApp = BasicUtil.getWebsiteApp();
        if (websiteApp != null) {
            String appId = websiteApp.getAppId();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.like(StringUtils.isNotBlank((CharSequence)manager.getManagerName()), ManagerEntity::getManagerName, (Object)manager.getManagerName());
            wrapper.like(StringUtils.isNotBlank((CharSequence)manager.getManagerNickName()), ManagerEntity::getManagerNickName, (Object)manager.getManagerNickName());
            wrapper.eq(StringUtils.isNotBlank((CharSequence)manager.getRoleIds()), ManagerEntity::getRoleIds, (Object)manager.getRoleIds());
            wrapper.apply("APP_ID={0}", new Object[]{appId});
            managerList = this.managerBiz.list((Wrapper)wrapper);
        } else {
            managerList = this.managerBiz.query(manager);
        }
        List<ManagerEntity> allManager = this.managerBiz.queryAllManager(managerList);
        return ResultData.build().success((Object)BasicUtil.filter(new EUListBean(allManager, (int)BasicUtil.endPage(allManager).getTotal()), "managerPassword", "updateBy", "createBy", "del"));
    }

    @ApiOperation(value="\u67e5\u8be2\u7ba1\u7406\u5458\u5217\u8868,\u53bb\u6389\u5f53\u524d\u7ba1\u7406\u5458id\uff0c\u786e\u4fdd\u4e0d\u80fd\u5220\u9664\u548c\u4fee\u6539\u81ea\u5df1")
    @GetMapping(value={"/query"})
    @RequiresPermissions(value={"basic:manager:view"})
    @ResponseBody
    public ResultData query(HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        List managerList;
        ManagerEntity manager = BasicUtil.getManager();
        BasicUtil.startPage();
        AppEntity websiteApp = BasicUtil.getWebsiteApp();
        if (websiteApp != null) {
            String appId = websiteApp.getAppId();
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId);
            managerList = this.managerBiz.list((Wrapper)wrapper);
        } else {
            managerList = this.managerBiz.list();
        }
        List<ManagerEntity> allManager = this.managerBiz.queryAllManager(managerList);
        for (ManagerEntity _manager : allManager) {
            assert (manager != null);
            if (!_manager.getId().equals(manager.getId())) continue;
            _manager.setId("0");
        }
        return ResultData.build().success((Object)new EUListBean(allManager, (int)BasicUtil.endPage(allManager).getTotal()));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ba1\u7406\u5458\u63a5\u53e3")
    @ApiImplicitParam(name="id", value="\u7ba1\u7406\u5458id", required=false, paramType="query")
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"basic:manager:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        ManagerEntity managerEntity;
        if (StringUtils.isNotEmpty((CharSequence)manager.getId())) {
            managerEntity = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)manager.getId())));
        } else {
            ManagerEntity managerSession = BasicUtil.getManager();
            if (managerSession == null) {
                return ResultData.build().error("\u7ba1\u7406\u5458\u5df2\u5931\u6548!");
            }
            managerEntity = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)managerSession.getId())));
        }
        if (managerEntity != null) {
            managerEntity.setManagerPassword("");
        }
        return ResultData.build().success((Object)managerEntity);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7ba1\u7406\u5458\u4fe1\u606f\u63a5\u53e3")
    @GetMapping(value={"/info"})
    @ResponseBody
    public ResultData info(HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity managerEntity = BasicUtil.getManager();
        if (managerEntity == null) {
            return ResultData.build().error("\u7ba1\u7406\u5458\u5df2\u5931\u6548!");
        }
        if ((managerEntity = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)managerEntity.getId())))) != null) {
            managerEntity.setManagerPassword("");
        }
        return ResultData.build().success((Object)managerEntity);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7ba1\u7406\u5458\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="managerName", value="\u5e10\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="managerNickName", value="\u6635\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="managerPassword", value="\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="roleIds", value="\u89d2\u8272IDS", required=true, paramType="query")})
    @LogAnn(title="\u4fdd\u5b58\u7ba1\u7406\u5458\u5b9e\u4f53", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"basic:manager:save"})
    public ResultData save(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)manager.getManagerName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.name")}));
        }
        if (!StringUtil.checkLength(manager.getManagerName() + "", 6, 15)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.name"), "6", "15"}));
        }
        if (this.managerBiz.getManagerByManagerName(manager.getManagerName()) != null) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("manager.name")}));
        }
        if (!manager.getManagerName().matches("^[a-zA-Z0-9_]{6,15}$")) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager.name")}));
        }
        if (StringUtils.isNotBlank((CharSequence)manager.getManagerAdmin())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager")}));
        }
        manager.setManagerAdmin("");
        if (StringUtils.isBlank((CharSequence)manager.getManagerNickName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.nickname")}));
        }
        if (!StringUtil.checkLength(manager.getManagerNickName() + "", 1, 15)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.nickname"), "1", "15"}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getRoleIds())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.roleid")}));
        }
        if (!StringUtil.checkLength(manager.getRoleIds() + "", 1, 50)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.roleid"), "1", "50"}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getManagerPassword())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.password")}));
        }
        if (!StringUtil.checkLength(manager.getManagerPassword() + "", 6, 30)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.password"), "6", "30"}));
        }
        if (!manager.getManagerPassword().matches("(?!^(\\d+|[a-zA-Z]+|[~!@#$%^&*?]+)$)^[\\w~!@#$%^&*?]{6,30}$")) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager.password")}));
        }
        manager.setManagerPassword(SecureUtil.md5((String)manager.getManagerPassword()));
        this.managerBiz.save((Object)manager);
        this.managerBiz.updateCache();
        return ResultData.build().success((Object)manager);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7ba1\u7406\u5458")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u7ba1\u7406\u5458", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"basic:manager:del"})
    public ResultData delete(@RequestBody List<ManagerEntity> managers, HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity manager = BasicUtil.getManager();
        Integer[] ids = new Integer[managers.size()];
        for (int i = 0; i < managers.size(); ++i) {
            ids[i] = Integer.parseInt(managers.get(i).getId());
        }
        List managerEntities = this.managerBiz.listByIds(Arrays.asList(ids));
        if (CollectionUtil.isNotEmpty(managerEntities = managerEntities.stream().filter(managerEntity -> ManagerAdminEnum.SUPER.toString().equals(managerEntity.getManagerAdmin()) || ManagerAdminEnum.SUPERADMIN.toString().equals(managerEntity.getManagerAdmin()) || manager.getId().equals(managerEntity.getId())).collect(Collectors.toList()))) {
            this.LOG.error("\u975e\u6cd5\u64cd\u4f5c\u5220\u9664\u8d85\u7ba1\u8d26\u53f7\u6216\u81ea\u5df1\u8d26\u53f7");
            return ResultData.build().error(this.getResString("fail", new String[]{this.getResString("remove")}));
        }
        this.managerBiz.removeByIds(Arrays.asList(ids));
        this.managerBiz.updateCache();
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u7ba1\u7406\u5458\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, paramType="query"), @ApiImplicitParam(name="managerNickName", value="\u6635\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="managerPassword", value="\u5bc6\u7801", required=false, paramType="query"), @ApiImplicitParam(name="roleIds", value="\u89d2\u8272IDS", required=true, paramType="query")})
    @LogAnn(title="\u66f4\u65b0\u7ba1\u7406\u5458\u4fe1\u606f", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"basic:manager:update"})
    public ResultData update(@ModelAttribute @ApiIgnore ManagerEntity manager) {
        this.managerBiz.updateCache();
        ManagerEntity _manager = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)manager.getId())));
        if (_manager == null) {
            return ResultData.build().error(this.getResString("err.not.exist", new String[]{this.getResString("managerName")}));
        }
        if (StringUtils.isNotBlank((CharSequence)manager.getManagerAdmin())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager")}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getManagerNickName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.nickname")}));
        }
        if (!StringUtil.checkLength(manager.getManagerNickName() + "", 1, 15)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.nickname"), "1", "15"}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getRoleIds())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.roleid")}));
        }
        if (!StringUtil.checkLength(manager.getRoleIds() + "", 1, 50)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.roleid"), "1", "50"}));
        }
        if (!StringUtils.isBlank((CharSequence)manager.getManagerPassword())) {
            if (!StringUtil.checkLength(manager.getManagerPassword() + "", 6, 30)) {
                return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.password"), "6", "30"}));
            }
            if (!manager.getManagerPassword().matches("(?!^(\\d+|[a-zA-Z]+|[~!@#$%^&*?]+)$)^[\\w~!@#$%^&*?]{6,30}$")) {
                return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager.password")}));
            }
            manager.setManagerPassword(SecureUtil.md5((String)manager.getManagerPassword()));
        } else {
            manager.setManagerPassword(null);
        }
        manager.setManagerName(_manager.getManagerName());
        this.managerBiz.updateById((Object)manager);
        return ResultData.build().success((Object)manager);
    }
}

