/**
 * Copyright (c) 2012-present 铭软科技(mingsoft.net)
 * 本软件及相关文档文件（以下简称“软件”）的版权归 铭软科技 所有
 * 遵循 铭软科技《服务协议》中的《保密条款》
 */








package net.mingsoft.basic.action.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseFileAction;
import net.mingsoft.basic.bean.UploadConfigBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.config.MSProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;

/**
 * 上传文件
 */
@Tag(name = "前端-基础接口")
@Controller
@RequestMapping("/file")
public class FileAction extends BaseFileAction {

	@Operation(summary =  "处理post请求上传文件")
	@Parameters({
			@Parameter(name = "uploadPath", description = "上传文件夹地址", required = false, in = ParameterIn.QUERY, style = ParameterStyle.FORM),
			@Parameter(name = "file", description = "文件流", required = false, style = ParameterStyle.FORM),
			@Parameter(name = "rename", description = "是否重命名", required =false, style = ParameterStyle.FORM, schema = @Schema(defaultValue = "true")),
			@Parameter(name = "appId", description = "上传路径是否需要拼接appId", required =false, style = ParameterStyle.FORM, schema = @Schema(defaultValue = "false")),
	})
	@PostMapping(value = "/upload")
	@ResponseBody
	public ResultData upload(@Parameter(hidden = true) UploadConfigBean bean, HttpServletRequest req, HttpServletResponse res) throws IOException {
		boolean uploadEnable = MSProperties.upload.enableWeb;

		if(uploadEnable){
			//非法路径过滤
			if(bean.getUploadPath()!=null&&(bean.getUploadPath().contains("../")||bean.getUploadPath().contains("..\\"))){
				return ResultData.build().error(getResString("err.error", new String[]{getResString("file.path")}));
			}
			// 是否需要拼接appId
			if (bean.isAppId()) {
				// 如果没传递uploadPath，则只拼接appId
				bean.setUploadPath(BasicUtil.getApp().getAppId() + File.separator + (StringUtils.isNotBlank(bean.getUploadPath()) ? bean.getUploadPath() : ""));
			}
			UploadConfigBean config = new UploadConfigBean(bean.getUploadPath(),bean.getFile(),null,false,bean.isRename());
			return this.upload(config);
		}else {
			return ResultData.build().error(getResString("insufficient.permissions"));
		}

	}

}
