/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.filter;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.IoUtil;
import cn.hutool.json.JSONUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.JsoupUtil;
import org.apache.commons.lang3.StringUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private HttpServletRequest request = null;
    private List<String> excludesFiled = new ArrayList<String>();

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public XssHttpServletRequestWrapper(HttpServletRequest request, List<String> excludesFiled) {
        super(request);
        this.request = request;
        if (CollectionUtil.isNotEmpty(excludesFiled)) {
            this.excludesFiled.addAll(excludesFiled);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        FastByteArrayOutputStream read = IoUtil.read((InputStream)this.request.getInputStream());
        String tmp = read.toString();
        if (JSONUtil.isTypeJSON((String)tmp)) {
            if (JSONUtil.isTypeJSONArray((String)tmp)) {
                List jsonList = JSONUtil.toList((String)tmp, Map.class);
                jsonList.forEach(map -> {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key = iterator.next().toString();
                        JsoupUtil.cleanOrSqlInjection(key);
                        if (!(map.get(key) instanceof String) || this.excludesFiled.contains(key)) continue;
                        JsoupUtil.cleanOrSqlInjection(String.valueOf(map.get(key)));
                    }
                });
            } else {
                Map jsonMap = (Map)JSONUtil.toBean((String)tmp, Map.class);
                Iterator iterator = jsonMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    JsoupUtil.cleanOrSqlInjection(key);
                    if (!(jsonMap.get(key) instanceof String) || this.excludesFiled.contains(key)) continue;
                    JsoupUtil.cleanOrSqlInjection(String.valueOf(jsonMap.get(key)));
                }
            }
        }
        if (JsoupUtil.hasXSS(tmp)) {
            throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u5b58\u5728xss\u653b\u51fb");
        }
        return new WrappedServletInputStream(new ByteArrayInputStream(read.toByteArray()));
    }

    public String getParameter(String name) {
        String value = super.getParameter(name = JsoupUtil.cleanOrSqlInjection(name));
        if (StringUtils.isNotBlank((CharSequence)value) && !this.excludesFiled.contains(name)) {
            value = JsoupUtil.cleanOrSqlInjection(value);
        }
        return value;
    }

    public Map getParameterMap() {
        Map map = super.getParameterMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Iterator entries = map.entrySet().iterator();
        String name = "";
        String value = "";
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            if (this.excludesFiled.contains(name)) {
                returnMap.put(name, value.trim());
                continue;
            }
            returnMap.put(JsoupUtil.cleanOrSqlInjection(name), JsoupUtil.cleanOrSqlInjection(value).trim());
        }
        return returnMap;
    }

    public String[] getParameterValues(String name) {
        String[] arr = super.getParameterValues(name);
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                if (this.excludesFiled.contains(name)) continue;
                arr[i] = JsoupUtil.cleanOrSqlInjection(arr[i]);
            }
        }
        return arr;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name = JsoupUtil.cleanOrSqlInjection(name));
        if (StringUtils.isNotBlank((CharSequence)value) && !this.excludesFiled.contains(name)) {
            value = JsoupUtil.cleanOrSqlInjection(value);
        }
        return value;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest req) {
        if (req instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)req).getRequest();
        }
        return req;
    }

    private class WrappedServletInputStream
    extends ServletInputStream {
        private InputStream stream;

        public void setStream(InputStream stream) {
            this.stream = stream;
        }

        public WrappedServletInputStream(InputStream stream) {
            this.stream = stream;
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

