/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import java.io.File;
import java.io.IOException;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.config.MSProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public abstract class BaseFileAction
extends BaseAction {
    public ResultData upload(Config config) throws IOException {
        String realPath;
        String uploadMapping = MSProperties.upload.mapping;
        String uploadFileDenied = MSProperties.upload.denied;
        String uploadFloderPath = MSProperties.upload.path;
        String[] errorType = uploadFileDenied.split(",");
        String fileName = config.getFile().getOriginalFilename();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return ResultData.build().error("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if ((fileName = FileNameUtil.cleanInvalid((String)fileName)).lastIndexOf(".") < 0) {
            this.LOG.info("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef:{}", (Object)fileName);
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("file.name")}));
        }
        String fileType = FileUtil.getSuffix((String)fileName);
        String string = realPath = config.uploadFloderPath ? BasicUtil.getRealPath("") : BasicUtil.getRealPath(uploadFloderPath);
        if (StringUtils.isNotBlank((CharSequence)config.getRootPath())) {
            realPath = config.getRootPath();
        }
        for (String type : errorType) {
            if (!fileType.equalsIgnoreCase(type)) continue;
            this.LOG.info("\u6587\u4ef6\u7c7b\u578b\u88ab\u62d2\u7edd:{}", (Object)fileType);
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("file.type")}));
        }
        if (config.isRename()) {
            fileName = System.currentTimeMillis() + "." + fileType;
        }
        String uploadFolder = realPath + File.separator;
        if (StringUtils.isNotBlank((CharSequence)config.getUploadPath())) {
            uploadFolder = uploadFolder + config.getUploadPath() + File.separator;
        }
        File saveFolder = new File(uploadFolder);
        File saveFile = new File(uploadFolder, fileName);
        if (!saveFolder.exists()) {
            FileUtil.mkdir((File)saveFolder);
        }
        config.getFile().transferTo(saveFile);
        String path = (config.isUploadFloderPath() ? "" : uploadMapping.replace("**", "")) + uploadFolder.replace(realPath, "") + "/" + fileName;
        return ResultData.build().success((Object)new File("/" + path).getPath().replace("\\", "/").replace("//", "/"));
    }

    public ResultData uploadTemplate(Config config) throws IOException {
        String uploadTemplatePath = MSProperties.upload.template;
        String uploadFileDenied = MSProperties.upload.denied;
        String[] errorType = uploadFileDenied.split(",");
        String fileName = config.getFile().getOriginalFilename();
        if (fileName.lastIndexOf(".") < 0) {
            this.LOG.info("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef:{}", (Object)fileName);
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("file.name")}));
        }
        String fileType = FileUtil.getSuffix((String)fileName);
        boolean isReal = new File(uploadTemplatePath).isAbsolute();
        String realPath = null;
        realPath = !isReal ? BasicUtil.getRealPath("") : uploadTemplatePath;
        if (!config.isRename()) {
            fileName = config.getFile().getOriginalFilename();
            if (fileName.endsWith(".") && System.getProperty("os.name").startsWith("Windows")) {
                this.LOG.info("\u6587\u4ef6\u7c7b\u578b\u88ab\u62d2\u7edd:{}", (Object)fileName);
                return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("file.type")}));
            }
            fileType = FileUtil.getSuffix((String)fileName);
        } else {
            fileName = System.currentTimeMillis() + "." + fileType;
        }
        for (String type : errorType) {
            if (!fileType.equalsIgnoreCase(type)) continue;
            this.LOG.info("\u6587\u4ef6\u7c7b\u578b\u88ab\u62d2\u7edd:{}", (Object)fileType);
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("file.type")}));
        }
        String uploadFolder = realPath + File.separator;
        if (StringUtils.isNotBlank((CharSequence)config.getUploadPath())) {
            uploadFolder = uploadFolder + config.getUploadPath() + File.separator;
        }
        File saveFolder = new File(uploadFolder);
        File saveFile = new File(uploadFolder, fileName);
        if (!saveFolder.exists()) {
            FileUtil.mkdir((File)saveFolder);
        }
        config.getFile().transferTo(saveFile);
        String path = uploadFolder.replace(realPath, "") + "/" + fileName;
        return ResultData.build().success((Object)new File("/" + path).getPath().replace("\\", "/").replace("//", "/"));
    }

    public static class Config
    extends Bean {
        private String rootPath;
        private boolean uploadFloderPath;

        public Config() {
        }

        public Config(String fileName, String rootPath) {
            this.rootPath = rootPath;
        }

        public Config(String uploadPath, MultipartFile file, String rootPath, boolean uploadFloderPath) {
            this.rootPath = rootPath;
            this.uploadFloderPath = uploadFloderPath;
            this.setUploadPath(uploadPath);
            this.setFile(file);
        }

        public Config(String uploadPath, MultipartFile file, String rootPath) {
            this.rootPath = rootPath;
            this.setUploadPath(uploadPath);
            this.setFile(file);
        }

        public Config(String uploadPath, MultipartFile file, String rootPath, boolean uploadFloderPath, boolean rename) {
            this.rootPath = rootPath;
            this.uploadFloderPath = uploadFloderPath;
            this.setUploadPath(uploadPath);
            this.setFile(file);
            this.setRename(rename);
        }

        public String getRootPath() {
            return this.rootPath;
        }

        public void setRootPath(String rootPath) {
            this.rootPath = rootPath;
        }

        public boolean isUploadFloderPath() {
            return this.uploadFloderPath;
        }

        public void setUploadFloderPath(boolean uploadFloderPath) {
            this.uploadFloderPath = uploadFloderPath;
        }
    }

    public static class Bean {
        private String uploadPath;
        private MultipartFile file;
        private boolean rename = true;
        private boolean appId = false;

        public boolean isAppId() {
            return this.appId;
        }

        public void setAppId(boolean appId) {
            this.appId = appId;
        }

        public boolean isRename() {
            return this.rename;
        }

        public void setRename(boolean rename) {
            this.rename = rename;
        }

        public String getUploadPath() {
            return this.uploadPath;
        }

        public void setUploadPath(String uploadPath) {
            this.uploadPath = uploadPath;
        }

        public MultipartFile getFile() {
            return this.file;
        }

        public void setFile(MultipartFile file) {
            this.file = file;
        }
    }
}

