/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.constant.e.ModelIsMenuEnum;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.entity.RoleModelEntity;
import net.mingsoft.basic.strategy.IModelStrategy;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u57fa\u7840\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}/model"})
public class ModelAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IModelStrategy modelStrategy;
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @ApiIgnore
    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"model:view"})
    public String index(HttpServletResponse response, HttpServletRequest request, ModelMap mode) {
        List<ModelEntity> parentModelList = this.modelStrategy.list();
        mode.addAttribute("parentModelList", (Object)JSONArray.toJSONString(parentModelList));
        return "/basic/model/index";
    }

    @ApiOperation(value="\u83dc\u5355\u5217\u8868\u63a5\u53e3")
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        List<ModelEntity> modelList = this.modelStrategy.list();
        if (CollectionUtil.isEmpty(modelList)) {
            return ResultData.build().success();
        }
        modelList.sort((o1, o2) -> {
            int sort1 = o1.getModelSort() == null ? 0 : o1.getModelSort();
            int sort2 = o2.getModelSort() == null ? 0 : o2.getModelSort();
            return sort2 - sort1;
        });
        EUListBean _list = new EUListBean(modelList, modelList.size());
        return ResultData.build().success((Object)_list);
    }

    @ApiOperation(value="\u83dc\u5355\u5b50\u96c6\u5217\u8868")
    @GetMapping(value={"/childList"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelTitle", value="\u83dc\u5355\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="modelId", value="\u7236\u7ea7\u83dc\u5355\u7f16\u53f7", required=false, paramType="query")})
    @RequiresPermissions(value={"model:view"})
    @ResponseBody
    public ResultData childList(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        List<ModelEntity> list = this.modelBiz.queryChildList(modelEntity);
        return ResultData.build().success(list);
    }

    @ApiOperation(value="\u83dc\u5355\u5bfc\u5165\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="menuStr", value="\u83dc\u5355json", required=true, paramType="query"), @ApiImplicitParam(name="modelId", value="\u7236\u7ea7\u83dc\u5355\u7f16\u53f7", required=true, paramType="query")})
    @LogAnn(title="\u5bfc\u5165\u83dc\u5355", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/import"})
    @ResponseBody
    public ResultData importMenu(String menuStr, int modelId) {
        if (StringUtils.isBlank((CharSequence)menuStr)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("menu")}));
        }
        try {
            List list = JSONArray.parseArray((String)menuStr, ModelEntity.class);
            ManagerEntity manager = BasicUtil.getManager();
            assert (manager != null);
            List modelTitles = list.stream().map(ModelEntity::getModelTitle).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(ModelEntity::getModelTitle, modelTitles);
            List modelEntityList = this.modelBiz.list((Wrapper)wrapper);
            if (list.size() != modelTitles.size() || CollUtil.isNotEmpty((Collection)modelEntityList)) {
                return ResultData.build().error("\u83dc\u5355\u5728\u5f53\u524d\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728");
            }
            for (ModelEntity modelEntity : list) {
                if (modelId < 1 && StringUtils.isNotBlank((CharSequence)modelEntity.getModelUrl())) {
                    return ResultData.build().error("\u5b50\u83dc\u5355\u4e0d\u80fd\u5728\u9876\u7ea7\u83dc\u5355\u5bfc\u5165!");
                }
                this.modelBiz.importModel(modelEntity, manager.getRoleId(), String.valueOf(modelId), modelId);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return ResultData.build().error(this.getResString("model.title.or.json"));
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("menu")}));
        }
        this.modelBiz.updateCache();
        return ResultData.build().success();
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u5757\u8868")
    @ApiImplicitParam(name="id", value="\u6a21\u5757\u7684\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"model:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.id")}));
        }
        ModelEntity _model = (ModelEntity)this.modelBiz.getEntity(Integer.parseInt(modelEntity.getId()));
        if (_model != null) {
            HashMap<String, ModelEntity> mode = new HashMap<String, ModelEntity>();
            if (_model.getModelId() != null) {
                ModelEntity parentModel = (ModelEntity)this.modelBiz.getEntity(_model.getModelId());
                mode.put("parentModel", parentModel);
            }
            mode.put("model", _model);
            return ResultData.build().success(mode);
        }
        return ResultData.build().success((Object)_model);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6a21\u5757\u8868\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelTitle", value="\u6a21\u5757\u7684\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="modelCode", value="\u6a21\u5757\u7f16\u7801", required=false, paramType="query"), @ApiImplicitParam(name="modelId", value="\u6a21\u5757\u7236id", required=false, paramType="query"), @ApiImplicitParam(name="modelUrl", value="\u94fe\u63a5\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="modelDatetime", value="\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="modelIcon", value="\u6a21\u5757\u56fe\u6807", required=false, paramType="query"), @ApiImplicitParam(name="modelSort", value="\u6a21\u5757\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="modelIsMenu", value="\u662f\u5426\u662f\u83dc\u5355", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u83dc\u5355\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="modelParentIds", value="\u7236\u7ea7\u7f16\u53f7\u96c6\u5408", required=false, paramType="query")})
    @LogAnn(title="\u4fdd\u5b58\u6a21\u5757\u8868\u5b9e\u4f53", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"model:save"})
    public ResultData save(@ModelAttribute @ApiIgnore ModelEntity model, HttpServletResponse response, HttpServletRequest request) {
        ModelEntity _model;
        ModelEntity modelEntity;
        if (StringUtils.isBlank((CharSequence)model.getModelTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.title")}));
        }
        if (!StringUtil.checkLength(model.getModelTitle() + "", 1, 10)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.title"), "1", "10"}));
        }
        if (model.getModelIsMenu().intValue() == ModelIsMenuEnum.MODEL_MEUN.toInt()) {
            modelEntity = new ModelEntity();
            modelEntity.setModelTitle(model.getModelTitle());
            modelEntity.setModelId(model.getModelId());
            modelEntity.setModelIsMenu(ModelIsMenuEnum.MODEL_MEUN.toInt());
            if (ObjectUtil.isNotEmpty((Object)this.modelBiz.getEntity(modelEntity))) {
                return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("model.title")}));
            }
        }
        model.setModelDatetime(new Timestamp(System.currentTimeMillis()));
        if (!StringUtils.isBlank((CharSequence)model.getModelIcon())) {
            model.setModelIcon(model.getModelIcon().replace("|", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)model.getModelCode()) && (_model = this.modelBiz.getEntityByModelCode(model.getModelCode())) != null) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("modelCode")}));
        }
        if (model.getModelSort() == null) {
            model.setModelSort(0);
        }
        if (model.getModelId() != null) {
            modelEntity = (ModelEntity)((Object)this.modelBiz.getById(model.getModelId()));
            if (StringUtils.isBlank((CharSequence)modelEntity.getModelParentIds())) {
                model.setModelParentIds(model.getModelId().toString());
            } else {
                model.setModelParentIds(modelEntity.getModelParentIds() + "," + model.getModelId().toString());
            }
        }
        this.modelBiz.save((Object)model);
        if (StringUtils.isNotEmpty((CharSequence)model.getId())) {
            ManagerEntity manager = BasicUtil.getManager();
            assert (manager != null);
            ArrayList<RoleModelEntity> roleModels = new ArrayList<RoleModelEntity>();
            for (String roleId : manager.getRoleIds().split(",")) {
                RoleModelEntity roleModel = new RoleModelEntity();
                roleModel.setModelId(Integer.parseInt(model.getId()));
                roleModel.setRoleId(Integer.parseInt(roleId));
                roleModels.add(roleModel);
            }
            this.roleModelBiz.saveBatch(roleModels, roleModels.size());
        }
        this.modelBiz.updateCache();
        return ResultData.build().success((Object)model.getId());
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6a21\u5757\u8868")
    @ApiImplicitParam(name="ids", value="\u6a21\u5757\u7f16\u53f7\uff0c\u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00", required=false, paramType="query")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u6a21\u5757\u8868", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"model:del"})
    public ResultData delete(HttpServletResponse response, HttpServletRequest request) {
        int[] ids = BasicUtil.getInts("ids", ",");
        this.modelBiz.delete(ids);
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u6a21\u5757\u8868\u4fe1\u606f\u6a21\u5757\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6a21\u5757\u7684\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="modelTitle", value="\u6a21\u5757\u7684\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="modelCode", value="\u6a21\u5757\u7f16\u7801", required=false, paramType="query"), @ApiImplicitParam(name="modelId", value="\u6a21\u5757\u7236id", required=false, paramType="query"), @ApiImplicitParam(name="modelUrl", value="\u94fe\u63a5\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="modelDatetime", value="\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="modelIcon", value="\u6a21\u5757\u56fe\u6807", required=false, paramType="query"), @ApiImplicitParam(name="modelSort", value="\u6a21\u5757\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="modelIsMenu", value="\u662f\u5426\u662f\u83dc\u5355", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u83dc\u5355\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="modelParentIds", value="\u7236\u7ea7\u7f16\u53f7\u96c6\u5408", required=false, paramType="query")})
    @LogAnn(title="\u66f4\u65b0\u6a21\u5757\u8868\u4fe1\u606f\u6a21\u5757\u8868", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"model:update"})
    @ResponseBody
    public ResultData update(@ModelAttribute @ApiIgnore ModelEntity model, HttpServletResponse response, HttpServletRequest request) {
        ModelEntity _model;
        if (StringUtil.isBlank(model.getModelTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.title")}));
        }
        if (!StringUtil.checkLength(model.getModelTitle() + "", 1, 10)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.title"), "1", "10"}));
        }
        if (model.getModelIsMenu().intValue() == ModelIsMenuEnum.MODEL_MEUN.toInt()) {
            ModelEntity modelEntity = new ModelEntity();
            modelEntity.setModelTitle(model.getModelTitle());
            modelEntity.setModelIsMenu(ModelIsMenuEnum.MODEL_MEUN.toInt());
            ModelEntity _modelEntity = (ModelEntity)((Object)this.modelBiz.getEntity(modelEntity));
            if (ObjectUtil.isNotEmpty((Object)((Object)_modelEntity)) && !_modelEntity.getId().equals(model.getId())) {
                return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("model.title")}));
            }
        }
        if ((_model = (ModelEntity)this.modelBiz.getEntity(Integer.parseInt(model.getId()))).getModelIsMenu() == 1 && model.getModelIsMenu() == 0) {
            return ResultData.build().error(this.getResString("model.is.menu"));
        }
        if (!StringUtil.isBlank(model.getModelIcon())) {
            model.setModelIcon(model.getModelIcon().replace("|", ""));
        }
        this.modelBiz.updateEntity(model);
        return ResultData.build().success((Object)model.getId());
    }

    @ApiOperation(value="\u6839\u636e\u7ba1\u7406\u5458ID\u67e5\u8be2\u6a21\u5757\u96c6\u5408")
    @ApiImplicitParam(name="managerId", value="\u7ba1\u7406\u5458id", required=true, paramType="path")
    @GetMapping(value={"/{managerId}/queryModelByRoleId"})
    @ResponseBody
    public ResultData queryModelByRoleId(@PathVariable @ApiIgnore int managerId, HttpServletRequest request, HttpServletResponse response) {
        ManagerEntity manager = (ManagerEntity)this.managerBiz.getEntity(managerId);
        if (manager == null) {
            return ResultData.build().error();
        }
        HashSet<ModelEntity> modelSet = new HashSet<ModelEntity>();
        for (String roleId : manager.getRoleIds().split(",")) {
            modelSet.addAll(this.modelBiz.queryModelByRoleId(Integer.parseInt(roleId)));
        }
        ArrayList modelList = new ArrayList(modelSet);
        return ResultData.build().success(modelList);
    }

    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757\u8868\u5217\u8868")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/modelList"})
    @ResponseBody
    public ResultData modelList(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        int roleId = BasicUtil.getInt("roleId");
        ManagerEntity managerSession = BasicUtil.getManager();
        boolean updateFlag = roleId != 0;
        List<ModelEntity> modelList = this.modelStrategy.list();
        ArrayList<ModelEntity> _modelList = new ArrayList<ModelEntity>();
        List<Object> roleModelList = new ArrayList();
        if (roleId > 0) {
            roleModelList = this.roleModelBiz.queryByRoleId(roleId);
        } else {
            HashSet<RoleModelEntity> roleSet = new HashSet<RoleModelEntity>();
            for (String id : managerSession.getRoleIds().split(",")) {
                roleSet.addAll(this.roleModelBiz.queryByRoleId(Integer.parseInt(id)));
            }
            roleModelList.addAll(roleSet);
        }
        ArrayList<ModelEntity> childModelList = new ArrayList<ModelEntity>();
        for (BaseEntity baseEntity : modelList) {
            ModelEntity _model = (ModelEntity)baseEntity;
            if (_model.getModelIsMenu() == 1) {
                _model.setModelChildList(new ArrayList<ModelEntity>());
                _modelList.add(_model);
                continue;
            }
            if (_model.getModelIsMenu() != 0) continue;
            childModelList.add(_model);
        }
        for (ModelEntity modelEntity2 : _modelList) {
            for (ModelEntity childModel : childModelList) {
                if (childModel.getModelId() != Integer.parseInt(modelEntity2.getId())) continue;
                modelEntity2.getModelChildList().add(childModel);
                for (RoleModelEntity roleModelEntity : roleModelList) {
                    if (roleModelEntity.getModelId() != Integer.parseInt(childModel.getId()) || !updateFlag) continue;
                    childModel.setChick(1);
                }
            }
        }
        EUListBean _list = new EUListBean(_modelList, _modelList.size());
        return ResultData.build().success((Object)_list);
    }
}

