/**
 * Copyright (c) 2012-present 铭软科技(mingsoft.net)
 * 本软件及相关文档文件（以下简称“软件”）的版权归 铭软科技 所有
 * 遵循 铭软科技《服务协议》中的《保密条款》
 */








package net.mingsoft.basic.action;

import cn.hutool.core.io.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.config.MSProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

/**
 *
 * 上传文件
 */
@Api(tags={"后端-基础接口"})
@Controller("ManageFileAction")
@RequestMapping("${ms.manager.path}/file")
public class ManageFileAction extends BaseFileAction {



	/**
	 * 处理post请求上传文件
	 * 可以自定义项目路径下任意文件夹
	 * @param req
	 *            HttpServletRequest对象
	 * @param res
	 *            HttpServletResponse 对象
	 * @throws ServletException
	 *             异常处理
	 * @throws IOException
	 *             异常处理
	 */
	@ApiOperation(value = "处理post请求上传文件")
	@LogAnn(title = "处理post请求上传文件",businessType= BusinessTypeEnum.OTHER)
	@ApiImplicitParams({
			@ApiImplicitParam(name = "uploadPath", value = "上传文件夹地址", required =false,paramType="form"),
			@ApiImplicitParam(name = "file", value = "文件流", dataType="__file",required =false,paramType="form"),
			@ApiImplicitParam(name = "rename", value = "是否重命名", required =false,paramType="form",defaultValue="true"),
			@ApiImplicitParam(name = "appId", value = "上传路径是否需要拼接appId", required =false,paramType="form",defaultValue="false"),
			@ApiImplicitParam(name = "uploadFloderPath", value = "是否修改上传目录", required =false,paramType="form",defaultValue="false"),
	})
	@PostMapping(value = "/upload",consumes = "multipart/*",headers = "content-type=multipart/form-data")
	@ResponseBody
	public ResultData upload(@ApiIgnore Bean bean,@ApiIgnore boolean uploadFloderPath, HttpServletRequest req, HttpServletResponse res) throws IOException {
		//非法路径过滤
		if(checkUploadPath(bean)){
			return ResultData.build().error();
		}
		// 是否需要拼接appId
		if (bean.isAppId()) {
			bean.setUploadPath(BasicUtil.getApp().getAppId() + File.separator + bean.getUploadPath());
		}

		Config config = new Config(bean.getUploadPath(),bean.getFile(),null,uploadFloderPath,bean.isRename());
		return this.upload(config);
	}

	@ApiOperation(value = "处理post请求上传模板文件")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "uploadPath", value = "上传文件夹地址", required =false,paramType="form"),
			@ApiImplicitParam(name = "file", value = "文件流", dataType="__file",required =false,paramType="form"),
			@ApiImplicitParam(name = "rename", value = "是否重命名", required =false,paramType="form",defaultValue="true"),
			@ApiImplicitParam(name = "appId", value = "上传路径是否需要拼接appId", required =false,paramType="form",defaultValue="false"),
			@ApiImplicitParam(name = "uploadFloderPath", value = "是否修改上传目录", required =false,paramType="form",defaultValue="false"),
	})
	@PostMapping("/uploadTemplate")
	@ResponseBody
	public ResultData uploadTemplate(@ApiIgnore Bean bean, @ApiIgnore boolean uploadFloderPath, HttpServletResponse res) throws IOException {
		String uploadTemplatePath = MSProperties.upload.template;
		//非法路径过滤
		if(checkUploadPath(bean)){
			return ResultData.build().error(getResString("err.error", new String[]{getResString("file.type")}));
		}
		if (StringUtils.isEmpty(bean.getUploadPath())) {
			bean.setUploadPath(uploadTemplatePath + File.separator +  BasicUtil.getApp().getAppId());
		} else if(!bean.getUploadPath().substring(0,uploadTemplatePath.length()).equalsIgnoreCase(uploadTemplatePath)){
			throw new BusinessException("uploadPath参数错误");
		}

		Config config = new Config(bean.getUploadPath(), bean.getFile(),null, uploadFloderPath, bean.isRename());
		return this.uploadTemplate(config);
	}

	protected boolean checkUploadPath(Bean bean){
		return (bean.getUploadPath()!=null&&(bean.getUploadPath().contains("../")||bean.getUploadPath().contains("..\\")));
	}

	@ApiOperation(value = "处理WEB-INF文件下载接口")
	@PostMapping(value = "/download")
	public void download(String filePath, HttpServletResponse response) {
		//检测空
		if (StringUtils.isEmpty(filePath)) {
			return;
		}
		//检测非法路径
		if (filePath.contains("../") || filePath.contains("..\\")) {
			return;
		}

		response.setHeader("content-type", "application/octet-stream");
		response.setContentType("application/octet-stream");
		String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
		try {
			fileName = new String(fileName.getBytes("UTF-8"),"ISO-8859-1");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
		try {
			FileUtil.writeToStream(BasicUtil.getRealPath("WEB-INF/" + filePath), response.getOutputStream());
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
