/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.aop;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.aop.BaseAop;
import net.mingsoft.basic.aop.SystemLogAop;
import net.mingsoft.basic.biz.ILogBiz;
import net.mingsoft.basic.entity.LogEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;

@Aspect
public abstract class BaseLogAop
extends BaseAop {
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    @Autowired
    private ILogBiz logBiz;
    private static final Logger LOG = LoggerFactory.getLogger(SystemLogAop.class);

    public abstract String getUserName();

    public abstract boolean isCut(LogAnn var1);

    @Pointcut(value="@annotation(net.mingsoft.basic.annotation.LogAnn)")
    public void logPointCut() {
    }

    @AfterReturning(pointcut="logPointCut()", returning="result")
    public void doAfterReturning(JoinPoint joinPoint, Object result) {
        this.handleLog(joinPoint, null, result);
    }

    @AfterThrowing(value="logPointCut()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Exception e) {
        this.handleLog(joinPoint, e, null);
    }

    protected void handleLog(JoinPoint joinPoint, Exception e, Object result) {
        try {
            LogAnn controllerLog = this.getAnnotation(joinPoint, LogAnn.class);
            if (controllerLog == null) {
                return;
            }
            if (!this.isCut(controllerLog)) {
                return;
            }
            LogEntity logEntity = new LogEntity();
            if (controllerLog.saveId()) {
                BaseEntity baseEntity = this.getType(joinPoint, BaseEntity.class, true);
                if (baseEntity != null) {
                    logEntity.setBusinessId(baseEntity.getId());
                } else {
                    List list;
                    Object arg;
                    int n = 0;
                    Object[] args = joinPoint.getArgs();
                    Object[] objectArray = args;
                    int n2 = objectArray.length;
                    if (n < n2 && (arg = objectArray[n]) instanceof List && CollUtil.isNotEmpty((Collection)(list = (List)arg))) {
                        if (list.get(0) instanceof String) {
                            logEntity.setBusinessId(CollUtil.join((Iterable)list, (CharSequence)","));
                        } else if (list.get(0) instanceof BaseEntity) {
                            List collect = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
                            logEntity.setBusinessId(CollUtil.join(collect, (CharSequence)","));
                        }
                    }
                }
            }
            logEntity.setLogUser(this.getUserName());
            logEntity.setLogStatus(SUCCESS);
            String ip = BasicUtil.getIp();
            logEntity.setLogIp(ip);
            SimplePropertyPreFilter classAFilter = new SimplePropertyPreFilter(BaseEntity.class, new String[]{"id"});
            SerializeFilter[] filters = new SerializeFilter[]{classAFilter};
            logEntity.setLogResult(JSONObject.toJSONString((Object)result, (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat}));
            logEntity.setLogUrl(SpringUtil.getRequest().getRequestURI());
            if (e != null) {
                logEntity.setLogStatus(ERROR);
                logEntity.setLogErrorMsg(StringUtils.substring((String)e.getMessage(), (int)0, (int)4000));
            }
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            logEntity.setLogMethod(className + "." + methodName + "()");
            logEntity.setLogRequestMethod(SpringUtil.getRequest().getMethod());
            logEntity.setLogBusinessType(controllerLog.businessType().name().toLowerCase());
            logEntity.setLogTitle(controllerLog.title());
            logEntity.setLogUserType(controllerLog.operatorType().name().toLowerCase());
            if (controllerLog.saveRequestData()) {
                boolean isJson;
                boolean bl = isJson = StringUtils.isNotBlank((CharSequence)SpringUtil.getRequest().getContentType()) && MediaType.valueOf((String)SpringUtil.getRequest().getContentType()).includes(MediaType.APPLICATION_JSON);
                if (isJson) {
                    Object jsonParam = this.getJsonParam(joinPoint);
                    if (ObjectUtil.isNotNull((Object)jsonParam)) {
                        String jsonString = JSONObject.toJSONString((Object)jsonParam, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat});
                        logEntity.setLogParam(jsonString);
                    }
                } else {
                    Map map = SpringUtil.getRequest().getParameterMap();
                    String params = JSONObject.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat});
                    logEntity.setLogParam(params);
                }
            }
            logEntity.setCreateDate(new Date());
            this.logBiz.saveData(logEntity);
        }
        catch (Exception exp) {
            LOG.error("\u65e5\u5fd7\u8bb0\u5f55\u9519\u8bef:{}", (Object)exp.getMessage());
            exp.printStackTrace();
        }
    }
}

