/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.filter.XssHttpServletRequestWrapper;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSSEscapeFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(XSSEscapeFilter.class);
    private static boolean IS_INCLUDE_RICH_TEXT = false;
    public List<String> includes = new ArrayList<String>();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!this.handleIncludeURL(req, resp)) {
            filterChain.doFilter(request, response);
            return;
        }
        logger.debug("{}\u8bf7\u6c42\u88ab\u8fc7\u6ee4\u4e86", (Object)((HttpServletRequest)request).getRequestURI());
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
        filterChain.doFilter((ServletRequest)xssRequest, response);
    }

    private boolean handleIncludeURL(HttpServletRequest request, HttpServletResponse response) {
        if (this.includes == null || this.includes.isEmpty()) {
            return false;
        }
        String url = request.getServletPath();
        for (String pattern : this.includes) {
            Pattern p = Pattern.compile("^" + pattern);
            Matcher m = p.matcher(url);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String temp;
        String isIncludeRichText;
        if (logger.isDebugEnabled()) {
            logger.debug("xss filter init");
        }
        if (StringUtils.isNotBlank((CharSequence)(isIncludeRichText = filterConfig.getInitParameter("isIncludeRichText")))) {
            IS_INCLUDE_RICH_TEXT = BooleanUtils.toBoolean((String)isIncludeRichText);
        }
        if ((temp = filterConfig.getInitParameter("excludes")) != null) {
            String[] url = temp.split(",");
            for (int i = 0; url != null && i < url.length; ++i) {
                this.includes.add(url[i]);
            }
        }
    }

    public void destroy() {
    }
}

