/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.system.oshi.CpuInfo;
import cn.hutool.system.oshi.OshiUtil;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.ManagerModifyPwdBean;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.config.MSProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u57fa\u7840\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}"})
public class MainAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    DataSource dataSource;

    @ApiOperation(value="\u52a0\u8f7d\u540e\u53f0\u4e3b\u754c\u9762\uff0c\u5e76\u67e5\u8be2\u6570\u636e")
    @GetMapping(value={"/index", "/"})
    public String index(HttpServletRequest request) {
        String managerPath = MSProperties.manager.path;
        ManagerSessionEntity managerSession = this.getManagerBySession();
        List<Object> modelList = new ArrayList();
        ModelEntity model = new ModelEntity();
        modelList = this.modelBiz.queryModelByRoleId(managerSession.getRoleId());
        ArrayList<ModelEntity> _modelList = new ArrayList<ModelEntity>();
        for (int i = 0; i < modelList.size(); ++i) {
            ModelEntity _model = (ModelEntity)((Object)modelList.get(i));
            if (!StringUtils.isBlank((CharSequence)_model.getIsChild())) continue;
            _modelList.add(_model);
        }
        request.setAttribute("managerSession", (Object)managerSession);
        request.setAttribute("modelList", (Object)JSONObject.toJSONString(modelList));
        request.setAttribute("client", (Object)(BasicUtil.getDomain() + "/" + managerPath));
        request.setAttribute("app", (Object)BasicUtil.getApp());
        return "/index";
    }

    @GetMapping(value={"/main"})
    public String main(HttpServletRequest request) {
        return "/main";
    }

    @ApiOperation(value="\u4fee\u6539\u767b\u5f55\u5bc6\u7801\uff0c\u82e5\u4e0d\u586b\u5199\u5bc6\u7801\u5219\u8868\u793a\u4e0d\u4fee\u6539")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldManagerPassword", value="\u65e7\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="newManagerPassword", value="\u65b0\u5bc6\u7801", required=true, paramType="query")})
    @LogAnn(title="\u4fee\u6539\u767b\u5f55\u5bc6\u7801", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/updatePassword"})
    @ResponseBody
    public ResultData updatePassword(@ModelAttribute @ApiIgnore ManagerModifyPwdBean managerModifyPwdBean, HttpServletResponse response, HttpServletRequest request) {
        String newManagerPassword = managerModifyPwdBean.getNewManagerPassword();
        ManagerSessionEntity manager = this.getManagerBySession();
        if (StringUtils.isBlank((CharSequence)newManagerPassword) || StringUtils.isBlank((CharSequence)managerModifyPwdBean.getOldManagerPassword())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("managerPassword")}));
        }
        if (!managerModifyPwdBean.getOldManagerPassword().equals(manager.getManagerPassword())) {
            return ResultData.build().error(this.getResString("manager.password.old.err"));
        }
        if (!StringUtil.checkLength(newManagerPassword, 6, 30)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("managerPassword"), "6", "30"}));
        }
        manager.setManagerPassword(SecureUtil.md5((String)newManagerPassword));
        this.managerBiz.updateUserPasswordByUserName(manager);
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return ResultData.build().success();
    }

    @ApiOperation(value="\u9000\u51fa\u7cfb\u7edf")
    @GetMapping(value={"/loginOut"})
    @ResponseBody
    public ResultData loginOut(HttpServletRequest request) {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return ResultData.build().success();
    }

    @ApiOperation(value="\u52a0\u8f7dUI\u7684\u8868\u5355\u9875\u9762")
    @GetMapping(value={"/system"})
    public String system(HttpServletRequest request) {
        return "/system";
    }

    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/system"})
    @ResponseBody
    public ResultData system(HttpServletResponse response, HttpServletRequest request) {
        Properties props = System.getProperties();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CPU\u6838\u6570", String.valueOf(Runtime.getRuntime().availableProcessors()));
        map.put("\u865a\u62df\u673a\u5185\u5b58\u603b\u91cf", String.valueOf(Runtime.getRuntime().totalMemory() / 0x100000L));
        map.put("\u865a\u62df\u673a\u7a7a\u95f2\u5185\u5b58\u91cf", String.valueOf(Runtime.getRuntime().freeMemory() / 0x100000L));
        map.put("\u865a\u62df\u673a\u4f7f\u7528\u6700\u5927\u5185\u5b58\u91cf", String.valueOf(Runtime.getRuntime().maxMemory() / 0x100000L));
        map.put("\u7cfb\u7edf\u540d\u79f0", props.getProperty("os.name"));
        map.put("\u7cfb\u7edf\u6784\u67b6", props.getProperty("os.arch"));
        map.put("\u7cfb\u7edf\u7248\u672c", props.getProperty("os.version"));
        map.put("Java\u7248\u672c", props.getProperty("java.version"));
        map.put("Java\u5b89\u88c5\u8def\u5f84", props.getProperty("java.home"));
        CpuInfo cpu = OshiUtil.getCpuInfo();
        map.put("cpu\u4fe1\u606f", cpu.getCpuModel() + "" + cpu.getCpuNum());
        map.put("\u5185\u5b58\u603b\u91cf", OshiUtil.getMemory().getTotal() / 0x100000L);
        map.put("\u5185\u5b58\u53ef\u7528", OshiUtil.getMemory().getAvailable() / 0x100000L);
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData mtdt = connection.getMetaData();
            map.put("\u6570\u636e\u5e93\u94fe\u63a5", mtdt.getURL());
            map.put("\u6570\u636e\u5e93", mtdt.getDatabaseProductName());
            map.put("\u6570\u636e\u5e93\u7248\u672c", mtdt.getDatabaseProductVersion());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        ServletContext context = request.getServletContext();
        map.put("web\u5bb9\u5668", context.getServerInfo());
        map.put("\u53d1\u5e03\u8def\u5f84", context.getRealPath(""));
        return ResultData.build().success(map);
    }
}

