/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.strategy.ILoginStrategy;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u767b\u5f55\u7684\u57fa\u7840\u5e94\u7528\u5c42\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}"})
public class LoginAction
extends BaseAction {
    @Value(value="${ms.manager.path}")
    private String managerPath;
    @Autowired
    private IAppBiz appBiz;
    @Autowired
    private ILoginStrategy loginStrategy;

    @ApiOperation(value="\u52a0\u8f7d\u7ba1\u7406\u5458\u767b\u5f55\u754c\u9762")
    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request) {
        Subject currentSubject = SecurityUtils.getSubject();
        ManagerEntity user = (ManagerEntity)((Object)currentSubject.getPrincipal());
        if (user != null) {
            return "redirect:" + this.managerPath + "/index.do";
        }
        request.setAttribute("app", (Object)BasicUtil.getApp());
        return "/login";
    }

    @ApiOperation(value="\u9a8c\u8bc1\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="managerName", value="\u5e10\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="managerPassword", value="\u5bc6\u7801", required=true, paramType="query")})
    @PostMapping(value={"/login"})
    @ResponseBody
    public ResultData login(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletRequest request, HttpServletResponse response) {
        this.LOG.debug("basic checkLogin");
        if (!this.checkRandCode()) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("rand.code")}));
        }
        if (this.loginStrategy.login(manager).booleanValue()) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("manager.name.or.password")}));
    }
}

