/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.constant.e.CookieConstEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u7f51\u7ad9\u57fa\u672c\u4fe1\u606f\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/app/"})
public class AppAction
extends BaseAction {
    @Autowired
    private IAppBiz appBiz;

    @ApiOperation(value="\u8df3\u8f6c\u5230\u4fee\u6539\u9875\u9762")
    @ApiImplicitParam(name="appId", value="\u7ad9\u70b9ID", required=true, paramType="path")
    @GetMapping(value={"/{appId}/edit"})
    public String edit(ModelMap mode, @PathVariable @ApiIgnore int appId, HttpServletRequest request) {
        AppEntity app = null;
        if (appId < 0) {
            app = BasicUtil.getApp();
            if (app != null) {
                if (BasicUtil.getSession("appId") == null) {
                    BasicUtil.setSession("appId", (Object)app.getAppId());
                }
            } else {
                appId = (Integer)BasicUtil.getSession("appId");
                app = (AppEntity)((Object)this.appBiz.getById(Integer.valueOf(appId)));
            }
        } else {
            app = (AppEntity)((Object)this.appBiz.getById(Integer.valueOf(appId)));
        }
        if (this.isSystemManager()) {
            mode.addAttribute("SystemManager", (Object)true);
        } else {
            mode.addAttribute("SystemManager", (Object)false);
        }
        mode.addAttribute("app", (Object)app);
        mode.addAttribute("appId", (Object)appId);
        return "/basic/app/app";
    }

    @ApiOperation(value="\u83b7\u53d6\u7ad9\u70b9\u4fe1\u606f")
    @ApiImplicitParam(name="appId", value="\u7ad9\u70b9ID", required=true, paramType="path")
    @GetMapping(value={"/{appId}/get"})
    @ResponseBody
    public ResultData get(@PathVariable @ApiIgnore int appId) {
        AppEntity app = null;
        if (appId < 0) {
            app = BasicUtil.getApp();
            if (app != null) {
                if (BasicUtil.getSession("appId") == null) {
                    BasicUtil.setSession("appId", (Object)app.getAppId());
                }
            } else {
                appId = (Integer)BasicUtil.getSession("appId");
                app = (AppEntity)((Object)this.appBiz.getById(Integer.valueOf(appId)));
            }
        } else {
            app = (AppEntity)((Object)this.appBiz.getById(Integer.valueOf(appId)));
        }
        return ResultData.build().success((Object)app);
    }

    @ApiOperation(value="\u66f4\u65b0\u7ad9\u70b9\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appName", value="\u5e94\u7528\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="appDescription", value="\u5e94\u7528\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="appLogo", value="\u5e94\u7528logo", required=false, paramType="query"), @ApiImplicitParam(name="appDatetime", value="\u7ad9\u70b9\u65e5\u671f", required=false, paramType="query"), @ApiImplicitParam(name="appKeyword", value="\u7f51\u7ad9\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="appCopyright", value="\u7f51\u7ad9\u7248\u6743\u4fe1\u606f", required=false, paramType="query"), @ApiImplicitParam(name="appStyle", value="\u7f51\u7ad9\u91c7\u7528\u7684\u6a21\u677f\u98ce\u683c", required=false, paramType="query"), @ApiImplicitParam(name="appUrl", value="\u7f51\u7ad9\u57df\u540d", required=false, paramType="query"), @ApiImplicitParam(name="appManagerId", value="\u7ba1\u7406\u7ad9\u70b9\u7684\u7ba1\u7406\u5458id", required=false, paramType="query"), @ApiImplicitParam(name="appPayDate", value="\u5e94\u7528\u7eed\u8d39\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="appPay", value="\u5e94\u7528\u8d39\u7528\u6e05\u5355", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @LogAnn(title="\u66f4\u65b0\u7ad9\u70b9\u4fe1\u606f", businessType=BusinessTypeEnum.UPDATE)
    @RequiresPermissions(value={"app:update"})
    @ResponseBody
    public ResultData update(@ModelAttribute @ApiIgnore AppEntity app, ModelMap mode, HttpServletRequest request, HttpServletResponse response) {
        mode.clear();
        ManagerSessionEntity managerSession = this.getManagerBySession();
        if (managerSession == null) {
            return ResultData.build().error();
        }
        mode.addAttribute("managerSession", (Object)managerSession);
        if (super.validated("app", "app_dir", app.getAppDir(), app.getId(), "id")) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("app.dir")}));
        }
        if (StringUtil.isBlank(app.getAppDir())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("app.dir")}));
        }
        if (!StringUtil.checkLength(app.getAppDir() + "", 0, 10)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("app.dir"), "0", "10"}));
        }
        if (!this.isSystemManager()) {
            app.setAppPayDate(null);
            app.setAppPay(null);
        }
        int roleId = managerSession.getRoleId();
        String cookie = BasicUtil.getCookie(CookieConstEnum.PAGENO_COOKIE);
        int pageNo = 1;
        if (StringUtils.isNotBlank((CharSequence)cookie) && Integer.valueOf(cookie) > 0) {
            pageNo = Integer.valueOf(cookie);
        }
        mode.addAttribute("pageNo", (Object)pageNo);
        if (!this.checkForm(app, response)) {
            return ResultData.build().error();
        }
        if (StringUtils.isNotBlank((CharSequence)app.getAppLogo())) {
            app.setAppLogo(app.getAppLogo().replace("|", ""));
        }
        if (ObjectUtil.isNotNull((Object)app.getAppUrl())) {
            String url = app.getAppUrl();
            String[] _url = url.split("\r\n");
            StringBuffer sb = new StringBuffer();
            for (String temp : _url) {
                String lastChar = temp.trim().substring(temp.length() - 1);
                if (lastChar.equals("/") || lastChar.equals("\\")) {
                    sb.append(temp.substring(0, temp.trim().length() - 1));
                } else {
                    sb.append(temp);
                }
                sb.append("\r\n");
            }
            app.setAppUrl(sb.toString());
        }
        this.appBiz.updateById((Object)app);
        return ResultData.build().success();
    }

    public boolean checkForm(AppEntity app, HttpServletResponse response) {
        if (!StringUtil.checkLength(app.getAppKeyword(), 0, 1000)) {
            ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("appKeyword"), "0", "1000"}));
            return false;
        }
        if (!StringUtil.checkLength(app.getAppCopyright(), 0, 1000)) {
            ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("appCopyright"), "0", "1000"}));
            return false;
        }
        if (!StringUtil.checkLength(app.getAppDescription(), 0, 1000)) {
            ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("appDescrip"), "0", "1000"}));
            return false;
        }
        if (!StringUtil.checkLength(app.getAppName(), 1, 50)) {
            ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("appTitle"), "1", "50"}));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)app.getAppStyle()) && !StringUtil.checkLength(app.getAppStyle(), 1, 30)) {
            ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("appStyle"), "1", "30"}));
            return false;
        }
        if (ObjectUtil.isNotNull((Object)app.getAppHostUrl()) && !StringUtil.checkLength(app.getAppHostUrl(), 10, 150)) {
            ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("appUrl"), "10", "150"}));
            return false;
        }
        return true;
    }

    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u6709\u91cd\u590d\u7684\u57df\u540d")
    @GetMapping(value={"/checkUrl"})
    @ResponseBody
    public ResultData checkUrl(HttpServletRequest request) {
        if (request.getParameter("appUrl") != null) {
            if (this.appBiz.countByUrl(request.getParameter("appUrl")) > 0) {
                return ResultData.build().success();
            }
            return ResultData.build().error();
        }
        return ResultData.build().error();
    }
}

