/**
The MIT License (MIT) * Copyright (c) 2016 铭飞科技(mingsoft.net)

 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package net.mingsoft.basic.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.constant.ModelCode;
import net.mingsoft.basic.constant.e.CookieConstEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.util.ZipUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.basic.util.BasicUtil;
import springfox.documentation.annotations.ApiIgnore;

/**
 * 
 * 
 * <p>
 * <b>铭飞CMS-铭飞内容管理系统</b>
 * </p>
 * 
 * <p>
 * Copyright: Copyright (c) 2014 - 2015
 * </p>
 * 
 * <p>
 * Company:景德镇铭飞科技有限公司
 * </p>
 * 
 * @author 铭飞开发团队
 * 
 * @version 300-001-001
 * 
 *          <p>
 *          版权所有 铭飞科技
 *          </p>
 * 
 *          <p>
 *          Comments:获取有关模版文件夹或模版文件信息
 *          </p>
 * 
 *          <p>
 *          Create Date:2014-8-12
 *          </p>
 * 
 *          <p>
 *          Modification history:
 *          </p>
 */
@Api("获取有关模版文件夹或模版文件信息")
@Controller("/basicTemplate")
@RequestMapping("/${ms.manager.path}/template")
public class TemplateAction extends BaseAction {

	/**
	 * 站点业务层
	 */
	@Autowired
	private IAppBiz appBiz;
	
	
	private static String TEMPLATE = "templets";
	private static String MOBILE = "m";


	/**
	 * 查询模版风格供站点选择
	 * 
	 * @param model
	 * @param request
	 *            请求
	 * @return 模版文件集合
	 */
	@ApiOperation(value = "查询模版风格供站点选择")
	@GetMapping("/queryAppTemplateSkin")
	@ResponseBody
	public Map queryAppTemplateSkin(HttpServletRequest request) {
		List<String> folderNameList = (List<String>) this.queryTemplateFile(request);
		Map map = new HashMap();
		if (folderNameList != null) {
			map.put("fileName", folderNameList);
		}
		return map;
	}

	/**
	 * 查询模版文件供栏目选择
	 * 
	 * @param request
	 *            请求
	 * @return 返回列表集合
	 */
	@ApiOperation(value = "查询模版文件供栏目选择")
	@GetMapping("/queryTemplateFileForColumn")
	@ResponseBody
	public List<String> queryTemplateFileForColumn(HttpServletRequest request) {
		ManagerSessionEntity managerSession = getManagerBySession(request);
		String path = BasicUtil.getRealPath( TEMPLATE) + File.separator
				+ managerSession.getBasicId();
		int websiteId = managerSession.getBasicId();
		AppEntity website = (AppEntity) appBiz.getEntity(websiteId);
		path = path + File.separator + website.getAppStyle();
		LOG.debug("tempPath:" + path);
		List<String> listName = new ArrayList<String>();
		files(listName, new File(path), website.getAppStyle());
		return listName;
	}

	private void files(List list, File fileDir, String style) {
		if (fileDir.isDirectory()) {
			File files[] = fileDir.listFiles();
			for (int i = 0; i < files.length; i++) {
				File currFile = files[i];
				if (currFile.isFile()) {
					String ex = currFile.getName();
					if (ex.endsWith("htm") || ex.endsWith("html")) {
						String _pathName = new String();
						_pathName = files(currFile, style, _pathName);
						list.add(_pathName + currFile.getName());
					}
				} else if (currFile.isDirectory()
						&& !currFile.getName().equalsIgnoreCase(MOBILE)) {
					files(list, currFile, style);
				}
			}
		}
	}

	private String files(File file, String style, String pathName) {
		if (!file.getParentFile().getName().equals(style)) {
			pathName = file.getParentFile().getName() + "/" + pathName;
			pathName = files(file.getParentFile(), style, pathName);
		}
		return pathName;
	}

	/**
	 * 点击模版管理，获取所有的模版文件名
	 * 
	 * @param response
	 *            响应
	 * @param model
	 * @param request
	 *            请求
	 * @return 返回模版文件名集合
	 */
	@ApiOperation(value = "点击模版管理，获取所有的模版文件名")
	@ApiImplicitParam(name = "pageNo", value = "pageNo", required = true,paramType="query")
	@GetMapping("/queryTemplateSkin")
	protected String queryTemplateSkin(HttpServletResponse response,@ApiIgnore ModelMap model, HttpServletRequest request) {
		String pageNo = request.getParameter("pageNo");
		if (!NumberUtils.isNumber(pageNo)) {
			pageNo = "1";
		}
		ManagerSessionEntity managerSession = getManagerBySession(request);
		List<String> folderNameList = this.queryTemplateFile(request);
		model.addAttribute("folderNameList", folderNameList);
		model.addAttribute("websiteId", managerSession.getBasicId());
		int recordCount = 0;
		if (folderNameList!=null) {
			recordCount = folderNameList.size();
		}
		BasicUtil.setCookie( response, CookieConstEnum.PAGENO_COOKIE, pageNo);
		return "/basic/template/template_list";
	}

	/**
	 * 解压zip模版文件
	 * 
	 * @param fileUrl
	 *            文件路径
	 * @throws ZipException
	 * @throws IOException
	 */
	@ApiOperation(value ="解压zip模版文件")
	@ApiImplicitParam(name = "fileUrl", value = "文件路径", required = true,paramType="query")
	@GetMapping("/unZip")
	@ResponseBody
	@RequiresPermissions("template:upload")
	public String unZip(@ApiIgnore ModelMap model, HttpServletRequest request) throws  IOException {
		boolean hasDic = false;
		String entryName = "";
		String fileUrl = request.getParameter("fileUrl");
		// 创建文件对象
		File file = new File(BasicUtil.getRealPath( fileUrl));
		// 创建zip文件对象
		ZipUtil.unzip(file, new File(BasicUtil.getRealPath(fileUrl.substring(0, fileUrl.length() - file.getName().length()))));
		FileUtils.forceDelete(file);
		return entryName;
	}

	/**
	 * 删除模版
	 * 
	 * @param name
	 *            模版名称
	 * @param request
	 *            请求
	 * @param response
	 *            响应
	 */
	@ApiOperation(value = "删除模版")
	@ApiImplicitParam(name = "fileName", value = "模版名称", required = true,paramType="query")
	@PostMapping("/delete")
	@ResponseBody
	@RequiresPermissions("template:del")
	public boolean delete(HttpServletRequest request) {
		String fileName = request.getParameter("fileName");
		String path = BasicUtil.getRealPath( TEMPLATE + File.separator
				+ BasicUtil.getAppId() + File.separator + fileName);
		try {
			FileUtils.deleteQuietly(new File(path));
			return true;
		} catch (Exception e) {
			return false;
		}
	}

	/**
	 * 获取模版路径
	 * 
	 * @param request
	 *            请求
	 * @param fileNameUrl
	 *            文件路径
	 * @return 返回路径
	 */
	private String getTemplateUrl(HttpServletRequest request, String fileNameUrl) {
		ManagerSessionEntity managerSession = getManagerBySession(request);
		String templetsUrl = BasicUtil.getRealPath( TEMPLATE + File.separator
				+ managerSession.getBasicId() + File.separator + fileNameUrl);
		return templetsUrl;
	}

	/**
	 * 显示子文件和子文件夹
	 * 
	 * @param response
	 *            响应
	 * @param model
	 * @param request
	 *            请求
	 * @return 返回文件名集合
	 */
	@ApiOperation(value = "显示子文件和子文件夹")
	@ApiImplicitParam(name = "skinFolderName", value = "skinFolderName", required = true,paramType="query")
	@GetMapping("/showChildFileAndFolder")
	public String showChildFileAndFolder(HttpServletResponse response,@ApiIgnore ModelMap model, HttpServletRequest request) {
		ManagerSessionEntity managerSession = getManagerBySession(request);
		List<String> folderNameList = null;
		String skinFolderName = request.getParameter("skinFolderName");
		File files[] = new File(BasicUtil.getRealPath( skinFolderName)).listFiles();
		if (files != null) {
			folderNameList = new ArrayList<String>();
			List<String> fileNameList = new ArrayList<String>();
			for (int i = 0; i < files.length; i++) {
				File currFile = files[i];
				String filter = BasicUtil.getRealPath(
						TEMPLATE + File.separator + BasicUtil.getAppId());
				LOG.debug("过滤路径" + filter);
				String temp = currFile.getPath().replace("\\", "/").replace(filter, "");
				if (currFile.isDirectory()) {
					folderNameList.add(temp);
				} else {
					fileNameList.add(temp);
				}
			}
			folderNameList.addAll(fileNameList);
			model.addAttribute("fileNameList", folderNameList);
		}
		String uploadFileUrl = skinFolderName;
		model.addAttribute("uploadFileUrl", uploadFileUrl);
		model.addAttribute("websiteId", managerSession.getBasicId());
		return "/basic/template/template_file_list";
	}

	/**
	 * 读取模版文件内容
	 * 
	 * @param model
	 * @param request
	 *            请求
	 * @return 返回文件内容
	 */
	@ApiOperation(value = "读取模版文件内容")
	@ApiImplicitParam(name = "fileName", value = "文件名称", required = true,paramType="query")
	@GetMapping("/readFileContent")
	@RequiresPermissions("template:update")
	public String readFileContent(@ApiIgnore ModelMap model, HttpServletRequest request) {
		String fileName = request.getParameter("fileName");
		if (!StringUtils.isEmpty(fileName)) {

			model.addAttribute("fileContent", FileReader.create(new File(BasicUtil.getRealPath( fileName))).readString());
		}
		model.addAttribute("name", new File(BasicUtil.getRealPath(fileName)).getName());
		model.addAttribute("fileName", fileName);
		model.addAttribute("fileNamePrefix", fileName.substring(0, fileName.lastIndexOf(File.separator) + 1));
		return "/basic/template/template_edit_file";
	}

	/**
	 * 删除模版文件
	 * 
	 * @param styleName
	 *            文件名称
	 * @param request
	 *            请求
	 */
	@ApiOperation(value = "删除模版文件")
	@ApiImplicitParam(name = "fileName", value = "文件名称", required = true,paramType="query")
	@PostMapping("/deleteTemplateFile")
	@ResponseBody
	public int deleteTemplateFile(HttpServletRequest request) {
		int pageNo = 1;
		ManagerSessionEntity managerSession = getManagerBySession(request);
		String fileName = request.getParameter("fileName");
		FileUtil.del(BasicUtil.getRealPath( TEMPLATE + File.separator
				+ managerSession.getBasicId() + File.separator + fileName));
		// 判断当前页码
		this.getHistoryPageNoByCookie(request);
		return pageNo;
	}

	/**
	 * 写入模版文件内容
	 * 
	 * @param model
	 * @param request
	 *            请求
	 * @param response
	 *            响应
	 * @throws IOException
	 */
	@ApiOperation(value = "写入模版文件内容")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "fileName", value = "文件名称", required = true,paramType="query"),
		@ApiImplicitParam(name = "oldFileName", value = "旧文件名称", required = true,paramType="query"),
		@ApiImplicitParam(name = "fileContent", value = "文件内容", required = true,paramType="query"),
	})
	@PostMapping("/writeFileContent")
	public void writeFileContent(@ApiIgnore ModelMap model, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String fileName = request.getParameter("fileName");
		String oldFileName = request.getParameter("oldFileName");
		String fileContent = request.getParameter("fileContent");
		if (!StringUtils.isEmpty(fileName)) {
			// 文件路径
			String templets = BasicUtil.getRealPath( fileName);
			LOG.debug(templets);
			FileWriter.create(new File(templets)).write(fileContent);
			if (!fileName.equals(oldFileName)) {
				// 得到一个待命名文件对象
				File newName = new File(templets);
				// 获取新名称文件的文件对象
				File oldName = new File(BasicUtil.getRealPath( oldFileName));
				// 进行重命名
				oldName.renameTo(newName);
				FileUtil.del(BasicUtil.getRealPath( oldFileName));
			}
			this.outJson(response, ModelCode.ROLE, true, null);
		}
	}

	/**
	 * 查询模版文件集合
	 * 
	 * @param request
	 *            请求
	 * @return 模版文件集合
	 */
	private List<String> queryTemplateFile(HttpServletRequest request) {
		ManagerSessionEntity managerSession = getManagerBySession(request);
		List<String> folderNameList = null;
		if (!isSystemManager(request)) {
			String templets = BasicUtil.getRealPath( TEMPLATE + File.separator
					+ managerSession.getBasicId() + File.separator);
			File file = new File(templets);
			String[] str = file.list();
			if (str!=null) {
				folderNameList = new ArrayList<String>();
				for (int i = 0; i < str.length; i++) {
					// 避免不为文件夹的文件显示
					if (str[i].indexOf(".") < 0) {
						folderNameList.add(str[i]);
					}
				}
			}
		}
		return folderNameList;
	}

}