package net.mingsoft.basic.action;

import java.sql.Timestamp;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.mingsoft.basic.biz.ICategoryBiz;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.CategoryEntity;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;

import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import springfox.documentation.annotations.ApiIgnore;
	
/**
 * 分类表管理控制层
 * @author 铭飞开发团队
 * @version 
 * 版本号：0.0<br/>
 * 创建日期：2017-8-22 10:03:38<br/>
 * 历史修订：<br/>
 */
@Api("分类表管理")
@Controller
@RequestMapping("/${ms.manager.path}/category")
public class CategoryAction extends net.mingsoft.basic.action.BaseAction{
	
	/**
	 * 注入分类表业务层
	 */	
	@Autowired
	private ICategoryBiz categoryBiz;
	
	/**m
	 * 返回主界面index
	 */
	@ApiOperation(value = "返回主界面index")
	@ApiImplicitParams({
	    @ApiImplicitParam(name = "modelTitle", value = "模块标题", required = true,paramType="query"),
	    @ApiImplicitParam(name = "modelId", value = "模块编号", required = true,paramType="query"),
    })
	@GetMapping("/index")
	public String index(HttpServletResponse response,HttpServletRequest request,ModelMap model){
		String modelTitle = BasicUtil.getString("modelTitle");
		int modelId = BasicUtil.getInt("modelId");
		if( modelId == 0){
			String modelCode = BasicUtil.getString("modelCode");
			modelId = BasicUtil.getModelCodeId(modelCode);
		}
		model.addAttribute("modelTitle",modelTitle);
		model.addAttribute("modelId",modelId);
		return  "/basic/category/index";
	}
	
	/**
	 * 查询分类表列表
	 * @param category 分类表实体
	 * <i>category参数包含字段信息参考：</i><br/>
	 * categoryId 类别ID<br/>
	 * categoryTitle 类别标题<br/>
	 * categorySort 类别排序<br/>
	 * categoryDatetime 类别发布时间<br/>
	 * categoryManagerid 发布用户ID<br/>
	 * categoryModelid 所属模块ID<br/>
	 * categoryCategoryid 父类别编号<br/>
	 * categorySmallimg 略缩图<br/>
	 * categoryAppid 应用编号<br/>
	 * categoryDescription 栏目描述<br/>
	 * categoryParentId 父类型编号<br/>
	 * categoryDictId 字典对应编号<br/>
	 * createBy 创建人<br/>
	 * createDate 创建时间<br/>
	 * updateBy 更新人<br/>
	 * updateDate 更新时间<br/>
	 * del 删除状态<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>[<br/>
	 * { <br/>
	 * categoryId: 类别ID<br/>
	 * categoryTitle: 类别标题<br/>
	 * categorySort: 类别排序<br/>
	 * categoryDatetime: 类别发布时间<br/>
	 * categoryManagerid: 发布用户ID<br/>
	 * categoryModelid: 所属模块ID<br/>
	 * categoryCategoryid: 父类别编号<br/>
	 * categorySmallimg: 略缩图<br/>
	 * categoryAppid: 应用编号<br/>
	 * categoryDescription: 栏目描述<br/>
	 * categoryParentId: 父类型编号<br/>
	 * categoryDictId: 字典对应编号<br/>
	 * createBy: 创建人<br/>
	 * createDate: 创建时间<br/>
	 * updateBy: 更新人<br/>
	 * updateDate: 更新时间<br/>
	 * del: 删除状态<br/>
	 * }<br/>
	 * ]</dd><br/>	 
	 */
	@ApiOperation(value = "查询分类表列表")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "categoryTitle", value = "类别的标题", required = true,paramType="query"),
		@ApiImplicitParam(name = "categorySort", value = "类别的排序", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryDateTime", value = "类别发布时间", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryManagerId", value = "发布用户编号(发布者编号)", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryModelId", value = "所属模块编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryCategoryId", value = "父类别的编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categorySmallImg", value = "缩略图", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryAppId", value = "分类所属应用编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryDescription", value = "栏目描述", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryParentId", value = "父类型编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryDictId", value = "字典对应编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "createBy", value = "创建用户编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "createDate", value = "创建日期", required = false,paramType="query"),
		@ApiImplicitParam(name = "modelId", value = "模块编号", required = true,paramType="path"),
	})
	@GetMapping("/list")
	@ResponseBody
	public void list(@ModelAttribute @ApiIgnore CategoryEntity category,HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model) {
		String modelId = request.getParameter("modelId");
		BasicUtil.setSession(SessionConstEnum.MANAGER_MODEL_CODE, modelId);
		// 获取登录的session
		ManagerSessionEntity managerSession = (ManagerSessionEntity) getManagerBySession(request);
		// 传入一个实体，提供查询条件
		category.setCategoryModelId(Integer.parseInt(modelId));
 
		AppEntity app = this.getApp(request);
		// 查询指定的appId下的分类
		category.setCategoryAppId(app.getAppId());
		// 判断是否为该网站总管理员，如果是管理员查询分类时则可以不受管理员限制，即可以查看所有的分类
		if (managerSession.getManagerId() != app.getAppManagerId()) {
			category.setCategoryManagerId(managerSession.getManagerId());
		}
		BasicUtil.startPage();
		List categoryList = categoryBiz.query(category);
		this.outJson(response, net.mingsoft.base.util.JSONArray.toJSONString(new EUListBean(categoryList,(int)BasicUtil.endPage(categoryList).getTotal()),new DoubleValueFilter(),new DateValueFilter("yyyy-MM-dd HH:mm:ss")));
	}
	
	/**
	 * 返回编辑界面category_form
	 */
	@ApiOperation(value = "返回编辑界面form")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "categoryId", value = "类别的编号自增长id", required = true,paramType="query"),
		@ApiImplicitParam(name = "modelTitle", value = "模块标题", required = true,paramType="query"),
		@ApiImplicitParam(name = "modelId", value = "模块编号", required = true,paramType="query"),
	})
	@GetMapping("/form")
	public String form(@ModelAttribute @ApiIgnore CategoryEntity category,HttpServletResponse response,HttpServletRequest request,@ApiIgnore ModelMap model){
		if(category.getCategoryId() > 0){
			BaseEntity categoryEntity = categoryBiz.getEntity(category.getCategoryId());			
			model.addAttribute("categoryEntity",categoryEntity);
		}
		request.setAttribute("modelTitle", BasicUtil.getString("modelTitle"));
		request.setAttribute("modelId", BasicUtil.getInt("modelId"));
		return  "/basic/category/form";
	}
	
	/**
	 * 获取分类表
	 * @param category 分类表实体
	 * <i>category参数包含字段信息参考：</i><br/>
	 * categoryId 类别ID<br/>
	 * categoryTitle 类别标题<br/>
	 * categorySort 类别排序<br/>
	 * categoryDatetime 类别发布时间<br/>
	 * categoryManagerid 发布用户ID<br/>
	 * categoryModelid 所属模块ID<br/>
	 * categoryCategoryid 父类别编号<br/>
	 * categorySmallimg 略缩图<br/>
	 * categoryAppid 应用编号<br/>
	 * categoryDescription 栏目描述<br/>
	 * categoryParentId 父类型编号<br/>
	 * categoryDictId 字典对应编号<br/>
	 * createBy 创建人<br/>
	 * createDate 创建时间<br/>
	 * updateBy 更新人<br/>
	 * updateDate 更新时间<br/>
	 * del 删除状态<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * categoryId: 类别ID<br/>
	 * categoryTitle: 类别标题<br/>
	 * categorySort: 类别排序<br/>
	 * categoryDatetime: 类别发布时间<br/>
	 * categoryManagerid: 发布用户ID<br/>
	 * categoryModelid: 所属模块ID<br/>
	 * categoryCategoryid: 父类别编号<br/>
	 * categorySmallimg: 略缩图<br/>
	 * categoryAppid: 应用编号<br/>
	 * categoryDescription: 栏目描述<br/>
	 * categoryParentId: 父类型编号<br/>
	 * categoryDictId: 字典对应编号<br/>
	 * createBy: 创建人<br/>
	 * createDate: 创建时间<br/>
	 * updateBy: 更新人<br/>
	 * updateDate: 更新时间<br/>
	 * del: 删除状态<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "获取分类表")
	@ApiImplicitParam(name = "categoryId", value = "类别的编号自增长id", required = true,paramType="query")
	@GetMapping("/get")
	@ResponseBody
	public void get(@ModelAttribute @ApiIgnore CategoryEntity category,HttpServletResponse response, HttpServletRequest request,@ApiIgnore ModelMap model){
		if(category.getCategoryId()<=0) {
			this.outJson(response, null, false, getResString("err.error", this.getResString("category.id")));
			return;
		}
		CategoryEntity _category = (CategoryEntity)categoryBiz.getEntity(category.getCategoryId());
		this.outJson(response, _category);
	}
	
	/**
	 * 保存分类表实体
	 * @param category 分类表实体
	 * <i>category参数包含字段信息参考：</i><br/>
	 * categoryId 类别ID<br/>
	 * categoryTitle 类别标题<br/>
	 * categorySmallimg 略缩图<br/>
	 * categoryDescription 栏目描述<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * categoryId: 类别ID<br/>
	 * categoryTitle: 类别标题<br/>
	 * categorySort: 类别排序<br/>
	 * categoryDatetime: 类别发布时间<br/>
	 * categoryManagerid: 发布用户ID<br/>
	 * categoryModelid: 所属模块ID<br/>
	 * categoryCategoryid: 父类别编号<br/>
	 * categorySmallimg: 略缩图<br/>
	 * categoryAppid: 应用编号<br/>
	 * categoryDescription: 栏目描述<br/>
	 * categoryParentId: 父类型编号<br/>
	 * categoryDictId: 字典对应编号<br/>
	 * createBy: 创建人<br/>
	 * createDate: 创建时间<br/>
	 * updateBy: 更新人<br/>
	 * updateDate: 更新时间<br/>
	 * del: 删除状态<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "保存分类表实体")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "categoryTitle", value = "类别的标题", required = true,paramType="query"),
		@ApiImplicitParam(name = "categorySort", value = "类别的排序", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryDateTime", value = "类别发布时间", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryManagerId", value = "发布用户编号(发布者编号)", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryModelId", value = "所属模块编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryCategoryId", value = "父类别的编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categorySmallImg", value = "缩略图", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryAppId", value = "分类所属应用编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryDescription", value = "栏目描述", required = true,paramType="query"),
		@ApiImplicitParam(name = "categoryParentId", value = "父类型编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryDictId", value = "字典对应编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "createBy", value = "创建用户编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "createDate", value = "创建日期", required = false,paramType="query"),
	})
	@PostMapping("/save")
	@ResponseBody
	public void save(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request) {
		//验证类别标题的值是否合法			
		if(StringUtil.isBlank(category.getCategoryTitle())){
			this.outJson(response, null,false,getResString("err.empty", this.getResString("category.title")));
			return;			
		}
		if(!StringUtil.checkLength(category.getCategoryTitle()+"", 1, 50)){
			this.outJson(response, null, false, getResString("err.length", this.getResString("category.title"), "1", "50"));
			return;			
		}
		//验证栏目描述的值是否合法			
		if(!StringUtil.checkLength(category.getCategoryDescription()+"", 0, 45)){
			this.outJson(response, null, false, getResString("err.length", this.getResString("category.description"), "1", "45"));
			return;			
		}
		category.setCategoryManagerId(((ManagerEntity) getManagerBySession(request)).getManagerId());
		category.setCategoryDateTime(new Timestamp(System.currentTimeMillis()));
		category.setCategoryAppId(BasicUtil.getAppId());
		categoryBiz.saveEntity(category);
		this.outJson(response, JSONObject.toJSONString(category));
	}
	
	/**
	 * @param category 分类表实体
	 * <i>category参数包含字段信息参考：</i><br/>
	 * categoryId:多个categoryId直接用逗号隔开,例如categoryId=1,2,3,4
	 * 批量删除分类表
	 *            <dt><span class="strong">返回</span></dt><br/>
	 *            <dd>{code:"错误编码",<br/>
	 *            result:"true｜false",<br/>
	 *            resultMsg:"错误信息"<br/>
	 *            }</dd>
	 */
	@ApiOperation(value = "批量删除分类表")
	@PostMapping("/delete")
	@ResponseBody
	public void delete(@RequestBody List<CategoryEntity> categorys,HttpServletResponse response, HttpServletRequest request) {
		int[] ids = new int[categorys.size()];
		for(int i = 0;i<categorys.size();i++){
			ids[i] = categorys.get(i).getCategoryId();
		}
		categoryBiz.delete(ids);		
		this.outJson(response, true);
	}
	
	/** 
	 * 更新分类表信息分类表
	 * @param category 分类表实体
	 * <i>category参数包含字段信息参考：</i><br/>
	 * categoryId 类别ID<br/>
	 * categoryTitle 类别标题<br/>
	 * categorySmallimg 略缩图<br/>
	 * <dt><span class="strong">返回</span></dt><br/>
	 * <dd>{ <br/>
	 * categoryId: 类别ID<br/>
	 * categoryTitle: 类别标题<br/>
	 * categorySort: 类别排序<br/>
	 * categoryDatetime: 类别发布时间<br/>
	 * categoryManagerid: 发布用户ID<br/>
	 * categoryModelid: 所属模块ID<br/>
	 * categoryCategoryid: 父类别编号<br/>
	 * categorySmallimg: 略缩图<br/>
	 * categoryAppid: 应用编号<br/>
	 * categoryDescription: 栏目描述<br/>
	 * categoryParentId: 父类型编号<br/>
	 * categoryDictId: 字典对应编号<br/>
	 * createBy: 创建人<br/>
	 * createDate: 创建时间<br/>
	 * updateBy: 更新人<br/>
	 * updateDate: 更新时间<br/>
	 * del: 删除状态<br/>
	 * }</dd><br/>
	 */
	@ApiOperation(value = "更新分类表信息分类表")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "categoryId", value = "类别的编号", required = true,paramType="query"),
		@ApiImplicitParam(name = "categoryTitle", value = "类别的标题", required = true,paramType="query"),
		@ApiImplicitParam(name = "categorySort", value = "类别的排序", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryDateTime", value = "类别发布时间", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryManagerId", value = "发布用户编号(发布者编号)", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryModelId", value = "所属模块编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryCategoryId", value = "父类别的编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categorySmallImg", value = "缩略图", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryAppId", value = "分类所属应用编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryDescription", value = "栏目描述", required = true,paramType="query"),
		@ApiImplicitParam(name = "categoryParentId", value = "父类型编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "categoryDictId", value = "字典对应编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "createBy", value = "创建用户编号", required = false,paramType="query"),
		@ApiImplicitParam(name = "createDate", value = "创建日期", required = false,paramType="query"),
	})
	@PostMapping("/update")
	@ResponseBody	 
	public void update(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response,
			HttpServletRequest request) {
		//验证类别标题的值是否合法			
		if(StringUtil.isBlank(category.getCategoryTitle())){
			this.outJson(response, null,false,getResString("err.empty", this.getResString("category.title")));
			return;			
		}
		if(!StringUtil.checkLength(category.getCategoryTitle()+"", 1, 50)){
			this.outJson(response, null, false, getResString("err.length", this.getResString("category.title"), "1", "50"));
			return;			
		}
		//验证栏目描述的值是否合法			
		if(!StringUtil.checkLength(category.getCategoryDescription()+"", 0, 45)){
			this.outJson(response, null, false, getResString("err.length", this.getResString("category.description"), "1", "45"));
			return;			
		}
		category.setCategoryManagerId(((ManagerEntity) getManagerBySession(request)).getManagerId());
		categoryBiz.updateEntity(category);
		this.outJson(response, JSONObject.toJSONString(category));
	}
	
//	/**
//	 * 根据分类id查找分类实体和它的父分类
//	 * 
//	 * @param categoryId
//	 * @param request
//	 * @param mode
//	 * @param response
//	 */
//	/**
//	 * 根据分类id查找分类实体和它的父分类
//	 * 
//	 * @param categoryId
//	 *            栏目id
//	 * @param request
//	 *            请求对象
//	 * @param mode
//	 * @param response
//	 */
//	@RequestMapping("/{categoryId}/query")
//	public void query(@PathVariable int categoryId, HttpServletRequest request, ModelMap mode,
//			HttpServletResponse response) {
//		// 根据分类id查询分类实体
//		CategoryEntity category = (CategoryEntity) categoryBiz.getEntity(categoryId);
//		// 如何分类实体不存在
//		if (category == null) {
//			return;
//		}
//		// 查询该分类的父分类
//		CategoryEntity categoryCategory = (CategoryEntity) categoryBiz.getEntity(category.getCategoryCategoryId());
//
//		List<CategoryEntity> list = new ArrayList<CategoryEntity>();
//		list.add(categoryCategory);
//		list.add(category);
//		this.outJson(response, JSONObject.toJSONString(list));
//	}

	
	
	/**
	 * 根据分类id查找分类子分类
	 * 
	 * @param categoryId
	 * @param request
	 * @param mode
	 * @param response
	 */
	@ApiOperation(value = "根据分类id查找分类子分类")
	@ApiImplicitParam(name = "categoryId", value = "分类id", required = true,paramType="path")
	@GetMapping("/{categoryId}/queryChildren")
	public void queryChildren(@PathVariable @ApiIgnore int categoryId, HttpServletRequest request,@ApiIgnore ModelMap mode,
			HttpServletResponse response) {
		CategoryEntity category = (CategoryEntity) this.categoryBiz.getEntity(categoryId);
		if (category != null) {
			List<CategoryEntity> list = this.categoryBiz.queryChilds(category);
			this.outJson(response, JSONObject.toJSONString(list));
		}

	}

//	/**
//	 * 加载栏目列表页并查询所有栏目下子栏目
//	 * 
//	 * @param categoryId
//	 *            栏目id
//	 * @param request
//	 *            请求对象
//	 * @param response
//	 *            响应对象
//	 * @return 栏目列表地址
//	 */
//	@RequestMapping("/{categoryId}/childList")
//	public String childList(@PathVariable int categoryId, HttpServletRequest request, HttpServletResponse response) {
//		String modelId = request.getParameter("modelId");
//		String categoryCategoryId = request.getParameter("categoryCategoryId");// 提供展开效果使用
//		BasicUtil.setSession( SessionConstEnum.MANAGER_MODEL_CODE, modelId);
//		// 获取登录的session
//		ManagerSessionEntity managerSession = (ManagerSessionEntity) getManagerBySession(request);
//		// 传入一个实体，提供查询条件
//		CategoryEntity category = new CategoryEntity();
//		category.setCategoryModelId(Integer.parseInt(modelId));
//
//		AppEntity app = this.getApp(request);
//		int appId = app.getAppId();
//		// 查询指定的appId下的分类
//		category.setCategoryAppId(appId);
//		// 判断是否为该网站总管理员，如果是管理员查询分类时则可以不受管理员限制，即可以查看所有的分类
//		if (managerSession.getManagerId() != app.getAppManagerId()) {
//			category.setCategoryManagerId(managerSession.getManagerId());
//		}
//
//		List<CategoryEntity> list = categoryBiz.queryChildrenCategory(categoryId, appId, this.getModelCodeId(request));
//
//		// 保存cookie值
//		BasicUtil.setCookie( response, CookieConstEnum.BACK_COOKIE, "/manager/category/list.do");
//		request.setAttribute("categoryCategoryId", categoryCategoryId);
//		request.setAttribute("categoryJson", JSONArray.toJSONString(list));
//		request.setAttribute("modelId", request.getParameter("modelId"));
//		return Const.VIEW + "/category/category_list";
//	}
		
}