/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.filter.DateValueFilter;
import com.mingsoft.base.filter.DoubleValueFilter;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.ICityBiz;
import net.mingsoft.basic.entity.CityEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/basic/city"})
public class CityAction
extends BaseAction {
    @Autowired
    private ICityBiz cityBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return this.view("/basic/city/index");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute CityEntity city, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        BasicUtil.startPage();
        List cityList = this.cityBiz.query((BaseEntity)city);
        this.outJson(response, (Object)JSONArray.toJSONString((Object)new EUListBean(cityList, (int)BasicUtil.endPage((List)cityList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @RequestMapping(value={"/form"})
    public String form(@ModelAttribute CityEntity city, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (StringUtil.isBlank((String)city.getId())) {
            BaseEntity cityEntity = this.cityBiz.getEntity(Integer.parseInt(city.getId()));
            model.addAttribute("cityEntity", (Object)cityEntity);
        }
        return this.view("/basic/city/form");
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute CityEntity city, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (StringUtil.isBlank((String)city.getId())) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("id")}));
            return;
        }
        CityEntity _city = (CityEntity)this.cityBiz.getEntity(Integer.parseInt(city.getId()));
        this.outJson(response, (BaseEntity)_city);
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    public void save(@ModelAttribute CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        this.cityBiz.saveEntity((BaseEntity)city);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)city));
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public void delete(@RequestBody List<CityEntity> citys, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[citys.size()];
        for (int i = 0; i < citys.size(); ++i) {
            ids[i] = Integer.parseInt(citys.get(i).getId());
        }
        this.cityBiz.delete(ids);
        this.outJson(response, true);
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        this.cityBiz.updateEntity((BaseEntity)city);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)city));
    }

    @RequestMapping(value={"/province"})
    @ResponseBody
    public void province(HttpServletResponse response, HttpServletRequest request) {
        List cityList = this.cityBiz.queryProvince();
        this.outJson(response, (Object)JSONArray.toJSONString((Object)cityList, (SerializeFilter[])new SerializeFilter[0]));
    }

    @RequestMapping(value={"/city"})
    @ResponseBody
    public void city(@ModelAttribute CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        List cityList = this.cityBiz.queryCity(city);
        this.outJson(response, (Object)JSONArray.toJSONString((Object)cityList, (SerializeFilter[])new SerializeFilter[0]));
    }

    @RequestMapping(value={"/county"})
    @ResponseBody
    public void county(@ModelAttribute CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        List cityList = this.cityBiz.queryCounty(city);
        this.outJson(response, (Object)JSONArray.toJSONString((Object)cityList, (SerializeFilter[])new SerializeFilter[0]));
    }
}

