/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.aop;

import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.util.AESUtil;
import com.mingsoft.util.StringUtil;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class BaseAop {
    protected final Logger LOG = Logger.getLogger(this.getClass());

    protected final <T> T getType(JoinPoint jp, Class<T> clazz) {
        Object[] objs;
        for (Object obj : objs = jp.getArgs()) {
            if (obj.getClass() != clazz) continue;
            return (T)obj;
        }
        return null;
    }

    protected final <T> T getType(JoinPoint jp, Class<T> clazz, boolean hasParent) {
        Object[] objs;
        for (Object obj : objs = jp.getArgs()) {
            if (obj.getClass() != clazz && obj.getClass().getSuperclass() != clazz) continue;
            return (T)obj;
        }
        return null;
    }

    protected String getCode(HttpServletRequest request) {
        return request.getParameter("mail_code");
    }

    protected String encryptByAES(int appId, String str) {
        if (StringUtil.isBlank((String)str)) {
            return "";
        }
        return AESUtil.encrypt((String)str, (String)StringUtil.Md5((String)(appId + "")).substring(16));
    }

    protected int getAppId(HttpServletRequest request) {
        AppEntity app = this.getApp(request);
        if (app != null) {
            return app.getAppId();
        }
        return 0;
    }

    protected AppEntity getApp(HttpServletRequest request) {
        IAppBiz websiteBiz = (IAppBiz)this.getBean(request.getServletContext(), "appBiz");
        AppEntity website = websiteBiz.getByUrl(this.getDomain(request));
        return website;
    }

    protected Object getBean(ServletContext sc, String beanName) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc).getBean(beanName);
    }

    protected String getDomain(HttpServletRequest request) {
        String path = request.getContextPath();
        String domain = request.getServerName();
        domain = request.getServerPort() == 80 ? domain + path : domain + ":" + request.getServerPort() + path;
        return domain;
    }

    protected Object getSession(HttpServletRequest request, BaseSessionEnum key) {
        return request.getSession().getAttribute(key.toString());
    }
}

