/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.parser;

import com.mingsoft.base.constant.Const;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.parser.IParser;
import com.mingsoft.parser.impl.general.GlobalCopyrightParser;
import com.mingsoft.parser.impl.general.GlobalDescripParser;
import com.mingsoft.parser.impl.general.GlobalHostParser;
import com.mingsoft.parser.impl.general.GlobalKeywordParser;
import com.mingsoft.parser.impl.general.GlobalLogoParser;
import com.mingsoft.parser.impl.general.GlobalNameParser;
import com.mingsoft.parser.impl.general.GlobalSkinUrlParser;
import com.mingsoft.parser.impl.general.GlobalUrlParser;
import com.mingsoft.parser.impl.general.IncludeParser;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.util.Map;

public abstract class IGeneralParser
extends IParser {
    public static final Object MOBILE = "mobilePath";
    protected AppEntity app;
    protected String mobilePath = "";
    protected String htmlContent;
    protected PageUtil page;
    protected String modelPath = "";
    protected Map map;
    protected int modelId;
    public static final String REQUEST_PARAM = "request";
    public static final String MODEL_ID = "modelId";
    public static final String CUR_COLUMNID = "curColumnId";
    public static final String PREVIOUS = "previous";
    public static final String NEXT = "next";
    public static final String CUR_PAGE_NO = "curPageNo";
    public static final String LIST_LINK_PATH = "listLinkPath";

    protected String parseGeneral() {
        this.htmlContent = new IncludeParser(this.htmlContent, Const.PROJECT_PATH + File.separator + "templets" + File.separator + this.app.getAppId() + File.separator + this.app.getAppStyle() + File.separator + this.modelPath + File.separator, this.mobilePath).parse();
        this.htmlContent = new GlobalCopyrightParser(this.htmlContent, this.app.getAppCopyright()).parse();
        this.htmlContent = new GlobalKeywordParser(this.htmlContent, this.app.getAppKeyword()).parse();
        this.htmlContent = new GlobalLogoParser(this.htmlContent, this.app.getAppLogo()).parse();
        this.htmlContent = new GlobalNameParser(this.htmlContent, this.app.getAppName()).parse();
        String tmpSkinUrl = this.app.getAppHostUrl() + File.separator + "templets" + File.separator + this.app.getAppId() + File.separator + this.app.getAppStyle() + File.separator;
        String linkUrl = this.app.getAppHostUrl() + File.separator + "html" + File.separator + this.app.getAppId();
        if (!StringUtil.isBlank((String)this.modelPath)) {
            tmpSkinUrl = tmpSkinUrl + File.separator + this.modelPath;
            linkUrl = linkUrl + File.separator + this.modelPath;
        }
        if (!StringUtil.isBlank((String)this.mobilePath)) {
            tmpSkinUrl = tmpSkinUrl + File.separator + this.mobilePath;
            linkUrl = linkUrl + File.separator + this.mobilePath;
        }
        this.htmlContent = new GlobalSkinUrlParser(this.htmlContent, tmpSkinUrl).parse();
        this.htmlContent = new GlobalUrlParser(this.htmlContent, linkUrl).parse();
        this.htmlContent = new GlobalHostParser(this.htmlContent, this.app.getAppHostUrl()).parse();
        this.htmlContent = new GlobalDescripParser(this.htmlContent, this.app.getAppDescription()).parse();
        this.htmlContent = this.parseRequestMap();
        return this.htmlContent;
    }

    protected String parseGeneral(String modelPath) {
        this.modelPath = modelPath;
        return this.parseGeneral();
    }

    private String parseRequestMap() {
        if (this.map != null && this.map.get(REQUEST_PARAM) != null) {
            Map params = (Map)this.map.get(REQUEST_PARAM);
            for (Map.Entry entry : params.entrySet()) {
                if (entry.getValue() == null) {
                    this.htmlContent = this.htmlContent.replace("{" + (String)entry.getKey() + "/}", "");
                    continue;
                }
                String value = (String)entry.getValue();
                if (StringUtil.isBlank((String)value)) continue;
                this.htmlContent = this.htmlContent.replace("{" + (String)entry.getKey() + "/}", value);
            }
        }
        return this.htmlContent;
    }

    protected String getWebsiteUrl() {
        if (!StringUtil.isBlank((String)this.mobilePath)) {
            return this.app.getAppHostUrl() + File.separator + "html" + File.separator + this.app.getAppId() + File.separator + this.mobilePath;
        }
        return this.app.getAppHostUrl() + File.separator + "html" + File.separator + this.app.getAppId();
    }

    public abstract String parse(String var1, Object ... var2);

    public String parse() {
        return this.parse();
    }

    public void init(Object ... obj) {
        for (Object o : obj) {
            if (o == null) continue;
            if (o instanceof AppEntity) {
                this.app = (AppEntity)((Object)o);
            }
            if (o instanceof PageUtil) {
                this.page = (PageUtil)o;
            }
            if (!(o instanceof Map)) continue;
            this.map = (Map)o;
        }
    }
}

