/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action.web;

import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IBasicBiz;
import com.mingsoft.basic.biz.IBasicLogBiz;
import com.mingsoft.basic.constant.e.CookieConstEnum;
import com.mingsoft.basic.constant.e.LogEnum;
import com.mingsoft.basic.entity.BasicEntity;
import com.mingsoft.basic.entity.BasicLogEntity;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="webBasicAction")
@RequestMapping(value={"/basic/"})
public class BasicAction
extends BaseAction {
    @Autowired
    private IBasicBiz basicBiz;
    @Autowired
    private IBasicLogBiz basicLogBiz;

    @RequestMapping(value={"/{basicId}/hit"})
    @ResponseBody
    public void hit(@PathVariable int basicId, HttpServletRequest request, HttpServletResponse response) {
        int isHit;
        if (basicId <= 0) {
            this.outString(response, "document.write(0)");
            return;
        }
        BasicEntity basic = (BasicEntity)this.basicBiz.getEntity(basicId);
        if (basic == null) {
            this.outString(response, "document.write(0)");
            return;
        }
        if (basic.getBasicAppId() != this.getAppId(request)) {
            this.outString(response, "document.write(0)");
            return;
        }
        boolean isShow = this.getBoolean(request, "isShow");
        if (isShow) {
            this.outString(response, "document.write(" + basic.getBasicHit() + ")");
            return;
        }
        String str = this.getCookie(request, CookieConstEnum.BASIC_HIT);
        BasicLogEntity basicLog = new BasicLogEntity();
        basicLog.setBasicLogAppId(this.getAppId(request));
        basicLog.setBasicLogDatetime(new Date());
        basicLog.setBasicLogIp(this.getIp(request));
        basicLog.setBasicLogBasicId(basicId);
        if (this.isMobileDevice(request)) {
            basicLog.setBasicLogIsMobile(LogEnum.MOBILE.toInt());
        }
        if ((isHit = this.basicLogBiz.count(basicLog)) > 0) {
            this.outString(response, "document.write(" + basic.getBasicHit() + ")");
            return;
        }
        this.basicBiz.updateHit(basicId, basic.getBasicHit() + 1);
        this.basicLogBiz.saveEntity(basicLog);
        this.outString(response, "document.write(" + (basic.getBasicHit() + 1) + ")");
    }
}

