/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.filter.DateValueFilter;
import com.mingsoft.base.filter.DoubleValueFilter;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IModelBiz;
import com.mingsoft.basic.biz.IRoleBiz;
import com.mingsoft.basic.biz.IRoleModelBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.basic.entity.RoleEntity;
import com.mingsoft.basic.entity.RoleModelEntity;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/basic/role"})
public class RoleAction
extends BaseAction {
    @Autowired
    private IRoleBiz roleBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return this.view("/basic/role/index");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute RoleEntity role, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        role.setRoleManagerId(managerSession.getManagerId());
        role.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List roleList = this.roleBiz.query((BaseEntity)role);
        this.outJson(response, (Object)JSONArray.toJSONString((Object)new EUListBean(roleList, (int)BasicUtil.endPage((List)roleList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @RequestMapping(value={"/{roleId}/queryByRole"})
    @ResponseBody
    public void queryByRole(@PathVariable int roleId, HttpServletResponse response) {
        List models = this.modelBiz.queryModelByRoleId(roleId);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)models));
    }

    @RequestMapping(value={"/form"})
    public String form(@ModelAttribute RoleEntity role, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (role.getRoleId() > 0) {
            BaseEntity roleEntity = this.roleBiz.getEntity(role.getRoleId());
            model.addAttribute("roleEntity", (Object)roleEntity);
        }
        return this.view("/basic/role/form");
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute RoleEntity role, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (role.getRoleId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("role.id")}));
            return;
        }
        RoleEntity _role = (RoleEntity)this.roleBiz.getEntity(role.getRoleId());
        this.outJson(response, (BaseEntity)_role);
    }

    @PostMapping(value={"/saveOrUpdateRole"})
    @ResponseBody
    @RequiresPermissions(value={"role:save"})
    public void saveOrUpdateRole(@ModelAttribute RoleEntity role, @RequestParam(value="ids[]", required=false) List<Integer> ids, HttpServletResponse response, HttpServletRequest request) {
        RoleEntity _role = new RoleEntity();
        _role.setRoleName(role.getRoleName());
        role.setAppId(BasicUtil.getAppId());
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        role.setRoleManagerId(managerSession.getManagerId());
        if (StringUtils.isEmpty((Object)role.getRoleName())) {
            this.outJson(response, (BaseEnum)ModelCode.ROLE, false, this.getResString("err.empty", new String[]{this.getResString("rolrName")}));
            return;
        }
        if (role.getRoleId() > 0) {
            if (this.roleBiz.getEntity((BaseEntity)_role) != null && !role.getRoleName().equals(BasicUtil.getString((String)"oldRoleName"))) {
                this.outJson(response, (BaseEnum)ModelCode.ROLE, false, this.getResString("roleName.exist"));
                return;
            }
            this.roleBiz.updateEntity((BaseEntity)role);
        } else {
            if (this.roleBiz.getEntity((BaseEntity)_role) != null) {
                this.outJson(response, (BaseEnum)ModelCode.ROLE, false, this.getResString("roleName.exist"));
                return;
            }
            this.roleBiz.saveEntity((BaseEntity)role);
        }
        ArrayList<RoleModelEntity> roleModelList = new ArrayList<RoleModelEntity>();
        if (ids != null) {
            for (Integer id : ids) {
                RoleModelEntity roleModel = new RoleModelEntity();
                roleModel.setRoleId(role.getRoleId());
                roleModel.setModelId(id.intValue());
                roleModelList.add(roleModel);
            }
            this.roleModelBiz.deleteEntity(role.getRoleId());
            this.roleModelBiz.saveEntity(roleModelList);
        } else {
            this.roleModelBiz.deleteEntity(role.getRoleId());
        }
        this.outJson(response, (Object)JSONObject.toJSONString((Object)role));
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"role:del"})
    public void delete(@RequestBody List<RoleEntity> roles, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[roles.size()];
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int currentRoleId = managerSession.getManagerRoleID();
        for (int i = 0; i < roles.size(); ++i) {
            if (currentRoleId == roles.get(i).getRoleId()) continue;
            ids[i] = roles.get(i).getRoleId();
        }
        this.roleBiz.delete(ids);
        this.outJson(response, true);
    }
}

