/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.filter.DateValueFilter;
import com.mingsoft.base.filter.DoubleValueFilter;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IManagerBiz;
import com.mingsoft.basic.entity.ManagerEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.util.StringUtil;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/basic/manager"})
public class ManagerAction
extends BaseAction {
    @Autowired
    private IManagerBiz managerBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return this.view("/basic/manager/index");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        BasicUtil.startPage();
        List managerList = this.managerBiz.queryAllChildManager(managerSession.getManagerId());
        this.outJson(response, (Object)JSONArray.toJSONString((Object)new EUListBean(managerList, (int)BasicUtil.endPage((List)managerList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @RequestMapping(value={"/query"})
    @ResponseBody
    public void query(@ModelAttribute ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        BasicUtil.startPage();
        List managerList = this.managerBiz.queryAllChildManager(managerSession.getManagerId());
        for (ManagerEntity _manager : managerList) {
            if (_manager.getManagerId() != managerSession.getManagerId()) continue;
            _manager.setManagerId(0);
        }
        this.outJson(response, (Object)JSONArray.toJSONString((Object)new EUListBean(managerList, (int)BasicUtil.endPage((List)managerList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (manager.getManagerId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("manager.id")}));
            return;
        }
        ManagerEntity managerEntity = (ManagerEntity)this.managerBiz.getEntity(manager.getManagerId());
        managerEntity.setManagerPassword("");
        this.outJson(response, (BaseEntity)managerEntity);
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"manager:save"})
    public void save(@ModelAttribute ManagerEntity manager, HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity newManager = new ManagerEntity();
        newManager.setManagerName(manager.getManagerName());
        if (this.managerBiz.getEntity((BaseEntity)newManager) != null) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("manager.name")}));
            return;
        }
        if (StringUtil.isBlank((String)manager.getManagerName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.name")}));
            return;
        }
        if (!StringUtil.checkLength((String)(manager.getManagerName() + ""), (int)1, (int)15)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.name"), "1", "15"}));
            return;
        }
        if (StringUtil.isBlank((String)manager.getManagerNickName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.nickname")}));
            return;
        }
        if (!StringUtil.checkLength((String)(manager.getManagerNickName() + ""), (int)1, (int)15)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.nickname"), "1", "15"}));
            return;
        }
        if (StringUtil.isBlank((String)manager.getManagerPassword())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.password")}));
            return;
        }
        if (!StringUtil.checkLength((String)(manager.getManagerPassword() + ""), (int)1, (int)45)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.password"), "1", "45"}));
            return;
        }
        manager.setManagerPassword(StringUtil.Md5((String)manager.getManagerPassword()));
        manager.setManagerTime(new Date());
        this.managerBiz.saveEntity((BaseEntity)manager);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)manager));
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"manager:del"})
    public void delete(@RequestBody List<ManagerEntity> managers, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[managers.size()];
        for (int i = 0; i < managers.size(); ++i) {
            ids[i] = managers.get(i).getManagerId();
        }
        this.managerBiz.delete(ids);
        this.outJson(response, true);
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"manager:update"})
    public void update(@ModelAttribute ManagerEntity manager, HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity newManager = new ManagerEntity();
        newManager.setManagerName(manager.getManagerName());
        ManagerEntity _manager = (ManagerEntity)this.managerBiz.getEntity((BaseEntity)newManager);
        if (_manager != null && manager.getManagerId() != _manager.getManagerId()) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("manager.name")}));
            return;
        }
        if (StringUtil.isBlank((String)manager.getManagerName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.name")}));
            return;
        }
        if (!StringUtil.checkLength((String)(manager.getManagerName() + ""), (int)1, (int)15)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.name"), "1", "15"}));
            return;
        }
        if (StringUtil.isBlank((String)manager.getManagerNickName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.nickname")}));
            return;
        }
        if (!StringUtil.checkLength((String)(manager.getManagerNickName() + ""), (int)1, (int)15)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.nickname"), "1", "15"}));
            return;
        }
        if (StringUtil.isBlank((String)manager.getManagerPassword())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.password")}));
            return;
        }
        if (!StringUtil.checkLength((String)(manager.getManagerPassword() + ""), (int)1, (int)45)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.password"), "1", "45"}));
            return;
        }
        manager.setManagerPassword(StringUtil.Md5((String)manager.getManagerPassword()));
        this.managerBiz.updateEntity((BaseEntity)manager);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)manager));
    }
}

