/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IColumnBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.entity.ColumnEntity;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="basicColumnAction")
@RequestMapping(value={"/${managerPath}/column"})
public class ColumnAction
extends BaseAction {
    @Autowired
    private IColumnBiz columnBiz;
    @Value(value="${managerViewPath}")
    protected String managerViewPath;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        return this.view("/column/index");
    }

    @RequestMapping(value={"/add"})
    public String add(HttpServletRequest request, ModelMap model) {
        int appId = BasicUtil.getAppId();
        List list = this.columnBiz.queryAll(appId, this.getModelCodeId(request));
        ColumnEntity columnSuper = new ColumnEntity();
        model.addAttribute("appId", (Object)appId);
        model.addAttribute("columnSuper", (Object)columnSuper);
        model.addAttribute("column", (Object)new ColumnEntity());
        model.addAttribute("listColumn", (Object)com.alibaba.fastjson.JSONArray.toJSONString((Object)list));
        return this.view("/column/form");
    }

    protected boolean checkForm(ColumnEntity column, HttpServletResponse response) {
        if (StringUtil.isBlank((String)column.getCategoryTitle())) {
            this.outJson(response, (BaseEnum)ModelCode.COLUMN, false, this.getResString("err.empty", new String[]{this.getResString("categoryTitle")}));
            return false;
        }
        if (!StringUtil.checkLength((String)column.getCategoryTitle(), (int)1, (int)31)) {
            this.outJson(response, (BaseEnum)ModelCode.COLUMN, false, this.getResString("err.length", new String[]{this.getResString("categoryTitle"), "1", "30"}));
            return false;
        }
        if (StringUtil.isBlank((Object)column.getColumnType())) {
            this.outJson(response, (BaseEnum)ModelCode.COLUMN, false, this.getResString("err.empty", new String[]{this.getResString("columnType")}));
            return false;
        }
        if (StringUtil.checkLength((String)column.getColumnDescrip(), (int)0, (int)500)) {
            column.setColumnDescrip(StringUtil.subString((String)column.getColumnDescrip(), (int)500));
        }
        if (StringUtil.checkLength((String)column.getColumnKeyword(), (int)0, (int)500)) {
            column.setColumnKeyword(StringUtil.subString((String)column.getColumnKeyword(), (int)500));
        }
        return true;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public void delete(HttpServletResponse response, HttpServletRequest request) {
        int[] ids = BasicUtil.getInts((String)"ids", (String)",");
        for (int i = 0; i < ids.length; ++i) {
            if (this.columnBiz.getEntity(ids[i]) == null) continue;
            this.columnBiz.deleteCategory(ids[i]);
        }
        this.outJson(response, true);
    }

    @RequestMapping(value={"/{columnId}/edit"})
    public String edit(@PathVariable int columnId, HttpServletRequest request, ModelMap model) {
        int appId = BasicUtil.getAppId();
        List list = new ArrayList();
        list = this.columnBiz.queryAll(appId, this.getModelCodeId(request));
        ColumnEntity column = (ColumnEntity)this.columnBiz.getEntity(columnId);
        model.addAttribute("appId", (Object)appId);
        model.addAttribute("column", (Object)column);
        model.addAttribute("columnc", (Object)column.getCategoryId());
        ColumnEntity columnSuper = new ColumnEntity();
        if (column.getCategoryCategoryId() != 0) {
            columnSuper = (ColumnEntity)this.columnBiz.getEntity(column.getCategoryCategoryId());
        }
        model.addAttribute("columnSuper", (Object)columnSuper);
        model.addAttribute("listColumn", (Object)com.alibaba.fastjson.JSONArray.toJSONString(list));
        return this.view("/column/form");
    }

    @RequestMapping(value={"/list"})
    public void list(@ModelAttribute ColumnEntity column, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        int websiteId = BasicUtil.getAppId();
        List list = this.columnBiz.queryAll(websiteId, this.getModelCodeId(request));
        EUListBean _list = new EUListBean(list, list.size());
        this.outJson(response, (Object)JSONArray.toJSONString((Object)_list, (SerializeFilter[])new SerializeFilter[0]));
    }

    @RequestMapping(value={"/save"})
    public void save(@ModelAttribute ColumnEntity column, HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkForm(column, response)) {
            return;
        }
        String file = this.getRealPath(request, "") + "html" + File.separator + column.getAppId();
        this.columnBiz.save(column, this.getModelCodeId(request), this.getManagerId(request), file);
        this.outJson(response, (BaseEnum)ModelCode.COLUMN, true, null, (Object)com.alibaba.fastjson.JSONArray.toJSONString((Object)column.getCategoryId()));
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute ColumnEntity column, HttpServletRequest request, HttpServletResponse response) {
        String file = this.getRealPath(request, null) + "html" + File.separator + column.getAppId();
        this.columnBiz.update(column, this.getModelCodeId(request), this.getManagerId(request), file);
        this.outJson(response, (BaseEnum)ModelCode.COLUMN, true, null, (Object)com.alibaba.fastjson.JSONArray.toJSONString((Object)column.getCategoryId()));
    }
}

