/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.security.session;

import com.google.common.collect.Sets;
import com.mingsoft.util.DateUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import net.mingsoft.basic.security.session.SessionDAO;
import net.mingsoft.basic.util.SpringUtil;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CacheSessionDAO
extends EnterpriseCacheSessionDAO
implements SessionDAO {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Serializable doCreate(Session session) {
        HttpServletRequest request = SpringUtil.getRequest();
        if (request != null) {
            String string = request.getServletPath();
        }
        super.doCreate(session);
        this.logger.debug("doCreate {} {}", (Object)session, (Object)(request != null ? request.getRequestURI() : ""));
        return session.getId();
    }

    protected void doDelete(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        super.doDelete(session);
        this.logger.debug("delete {} ", (Object)session.getId());
    }

    protected Session doReadSession(Serializable sessionId) {
        this.logger.debug("doReadSession {} ", (Object)sessionId);
        return super.doReadSession(sessionId);
    }

    protected void doUpdate(Session session) {
        this.logger.debug("doUpdate {} ", (Object)session.getId());
        if (session == null || session.getId() == null) {
            return;
        }
        HttpServletRequest request = SpringUtil.getRequest();
        if (request != null) {
            String string = request.getServletPath();
        }
        super.doUpdate(session);
    }

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        try {
            Session s = null;
            HttpServletRequest request = SpringUtil.getRequest();
            if (request != null) {
                String uri = request.getServletPath();
                s = (Session)request.getAttribute("session_" + sessionId);
            }
            if (s != null) {
                return s;
            }
            Session session = super.readSession(sessionId);
            if (request != null && session != null) {
                request.setAttribute("session_" + sessionId, (Object)session);
            }
            return session;
        }
        catch (UnknownSessionException e) {
            return null;
        }
    }

    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave) {
        this.logger.debug("getActiveSessions \u83b7\u53d6\u6d3b\u52a8\u4f1a\u8bdd");
        return this.getActiveSessions(includeLeave, null, null);
    }

    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave, Object principal, Session filterSession) {
        this.logger.debug("getActiveSessions");
        if (includeLeave && principal == null) {
            return this.getActiveSessions();
        }
        HashSet sessions = Sets.newHashSet();
        for (Session session : this.getActiveSessions()) {
            boolean isActiveSession = false;
            if (includeLeave || DateUtil.diffMonth((Date)session.getLastAccessTime(), (Date)new Date()) <= 3) {
                isActiveSession = true;
            }
            if (principal != null) {
                PrincipalCollection pc = (PrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                if (principal.toString().equals(pc != null ? pc.getPrimaryPrincipal().toString() : "")) {
                    isActiveSession = true;
                }
            }
            if (filterSession != null && filterSession.getId().equals(session.getId())) {
                isActiveSession = false;
            }
            if (!isActiveSession) continue;
            sessions.add(session);
        }
        return sessions;
    }
}

